/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.PeriodicPayment;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import de.adorsys.multibanking.hbci.model.HbciCycleMapper;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVDauerSEPANew;
import org.kapott.hbci.GV_Result.GVRPayment;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicPaymentJob
extends AbstractPaymentJob<PeriodicPayment> {
    private static final Logger log = LoggerFactory.getLogger(PeriodicPaymentJob.class);
    private final TransactionRequest<PeriodicPayment> transactionRequest;
    private GVDauerSEPANew hbciNewStandingOrderJob;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        PeriodicPayment standingOrder = (PeriodicPayment)this.transactionRequest.getTransaction();
        Konto src = this.getHbciKonto(passport);
        Konto dst = new Konto();
        dst.name = standingOrder.getOtherAccount().getOwner();
        dst.iban = standingOrder.getOtherAccount().getIban();
        dst.bic = standingOrder.getOtherAccount().getBic();
        this.hbciNewStandingOrderJob = new GVDauerSEPANew((HBCIPassportInternal)passport);
        this.hbciNewStandingOrderJob.setParam("src", src);
        this.hbciNewStandingOrderJob.setParam("dst", dst);
        this.hbciNewStandingOrderJob.setParam("btg", new Value(standingOrder.getAmount(), standingOrder.getCurrency()));
        this.hbciNewStandingOrderJob.setParam("usage", standingOrder.getUsage());
        if (standingOrder.getFirstExecutionDate() != null) {
            this.hbciNewStandingOrderJob.setParam("firstdate", standingOrder.getFirstExecutionDate().toString());
        }
        if (standingOrder.getCycle() != null) {
            this.hbciNewStandingOrderJob.setParam("timeunit", HbciCycleMapper.cycleToTimeunit(standingOrder.getCycle()));
            this.hbciNewStandingOrderJob.setParam("turnus", HbciCycleMapper.cycleToTurnus(standingOrder.getCycle()));
        }
        this.hbciNewStandingOrderJob.setParam("execday", standingOrder.getExecutionDay());
        if (standingOrder.getLastExecutionDate() != null) {
            this.hbciNewStandingOrderJob.setParam("lastdate", standingOrder.getLastExecutionDate().toString());
        }
        if (standingOrder.getPurposecode() != null) {
            this.hbciNewStandingOrderJob.setParam("purposecode", standingOrder.getPurposecode());
        }
        if (standingOrder.getEndToEndId() != null) {
            this.hbciNewStandingOrderJob.setParam("endtoendid", standingOrder.getEndToEndId());
        }
        this.hbciNewStandingOrderJob.verifyConstraints();
        return this.hbciNewStandingOrderJob;
    }

    @Override
    AbstractHBCIJob getHbciJob() {
        return this.hbciNewStandingOrderJob;
    }

    @Override
    TransactionRequest<PeriodicPayment> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    protected String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        return GVDauerSEPANew.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return ((GVRPayment)paymentGV).getOrderId();
    }

    public PeriodicPaymentJob(TransactionRequest<PeriodicPayment> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

