/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.Amount;
import de.adorsys.multibanking.domain.Frequency;
import de.adorsys.multibanking.domain.StandingOrder;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.StandingOrdersResponse;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.LoadStandingOrders;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVDauerSEPAList;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadStandingOrdersJob
extends ScaAwareJob<LoadStandingOrders, StandingOrdersResponse> {
    private static final Logger log = LoggerFactory.getLogger(LoadStandingOrdersJob.class);
    private final TransactionRequest<LoadStandingOrders> loadStandingOrdersRequest;
    private GVDauerSEPAList standingOrdersHbciJob;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        this.standingOrdersHbciJob = new GVDauerSEPAList((HBCIPassportInternal)passport);
        this.standingOrdersHbciJob.setParam("src", this.getHbciKonto(passport));
        return this.standingOrdersHbciJob;
    }

    @Override
    TransactionRequest<LoadStandingOrders> getTransactionRequest() {
        return this.loadStandingOrdersRequest;
    }

    @Override
    String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        return GVDauerSEPAList.getLowlevelName();
    }

    @Override
    public StandingOrdersResponse createJobResponse(PinTanPassport passport, HbciTanSubmit tanSubmit) {
        List standingOrders = ((GVRDauerList)this.standingOrdersHbciJob.getJobResult()).getEntries().stream().map(dauerAuftrag -> {
            StandingOrder standingOrder = new StandingOrder();
            standingOrder.setCreditorAccount(dauerAuftrag.other.iban);
            standingOrder.setCreditorName(dauerAuftrag.other.name);
            standingOrder.setTransactionAmount(new Amount(Currency.getInstance(dauerAuftrag.value.getCurr()), new BigDecimal(HBCIUtils.bigDecimal2String((BigDecimal)dauerAuftrag.value.getBigDecimalValue()))));
            standingOrder.setRemittanceInformationUnstructured(dauerAuftrag.usage);
            standingOrder.setBankTransactionCode(dauerAuftrag.orderid);
            Optional.ofNullable(dauerAuftrag.firstdate).ifPresent(date -> standingOrder.setStartDate(LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC).toLocalDate()));
            Optional.ofNullable(dauerAuftrag.lastdate).ifPresent(date -> standingOrder.setEndDate(LocalDateTime.ofInstant(date.toInstant(), ZoneOffset.UTC).toLocalDate()));
            standingOrder.setDayOfExecution(dauerAuftrag.execday);
            standingOrder.setEndToEndId(dauerAuftrag.endToEndId);
            standingOrder.setPurposeCode(dauerAuftrag.purposecode);
            switch (dauerAuftrag.turnus) {
                case 1: {
                    standingOrder.setFrequency(Frequency.MONTHLY);
                    break;
                }
                case 2: {
                    standingOrder.setFrequency(Frequency.TWO_MONTHLY);
                    break;
                }
                case 3: {
                    standingOrder.setFrequency(Frequency.QUARTERLY);
                    break;
                }
                case 6: {
                    standingOrder.setFrequency(Frequency.HALF_YEARLY);
                    break;
                }
                case 12: {
                    standingOrder.setFrequency(Frequency.YEARLY);
                }
            }
            return standingOrder;
        }).collect(Collectors.toList());
        return new StandingOrdersResponse(standingOrders);
    }

    public LoadStandingOrdersJob(TransactionRequest<LoadStandingOrders> loadStandingOrdersRequest) {
        this.loadStandingOrdersRequest = loadStandingOrdersRequest;
    }
}

