/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.PaymentStatus;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.PaymentStatusResponse;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.PaymentStatusReqest;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVInstanstUebSEPAStatus;
import org.kapott.hbci.GV_Result.GVRInstantUebSEPAStatus;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantPaymentStatusJob
extends ScaAwareJob<PaymentStatusReqest, PaymentStatusResponse> {
    private static final Logger log = LoggerFactory.getLogger(InstantPaymentStatusJob.class);
    private final TransactionRequest<PaymentStatusReqest> paymentStatusReqest;
    private GVInstanstUebSEPAStatus paymentStatusHbciJob;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        this.paymentStatusHbciJob = new GVInstanstUebSEPAStatus((HBCIPassportInternal)passport);
        this.paymentStatusHbciJob.setParam("my", this.getHbciKonto(passport));
        this.paymentStatusHbciJob.setParam("orderid", ((PaymentStatusReqest)this.paymentStatusReqest.getTransaction()).getPaymentId());
        return this.paymentStatusHbciJob;
    }

    @Override
    TransactionRequest<PaymentStatusReqest> getTransactionRequest() {
        return this.paymentStatusReqest;
    }

    @Override
    String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        return GVInstanstUebSEPAStatus.getLowlevelName();
    }

    @Override
    protected void checkExecuteStatus(HBCIExecStatus execStatus) {
    }

    @Override
    public PaymentStatusResponse createJobResponse(PinTanPassport passport, HbciTanSubmit tanSubmit) {
        GVRInstantUebSEPAStatus hbciStatus = (GVRInstantUebSEPAStatus)this.paymentStatusHbciJob.getJobResult();
        PaymentStatus paymentStatus = null;
        switch (hbciStatus.getStatus()) {
            case 1: {
                paymentStatus = PaymentStatus.CANC;
                break;
            }
            case 2: {
                paymentStatus = PaymentStatus.RJCT;
                break;
            }
            case 3: {
                paymentStatus = PaymentStatus.PDNG;
                break;
            }
            case 4: {
                paymentStatus = PaymentStatus.ACCC;
                break;
            }
            case 5: {
                paymentStatus = PaymentStatus.CANC;
                break;
            }
            case 6: {
                paymentStatus = PaymentStatus.RJCT;
                break;
            }
            case 7: {
                paymentStatus = PaymentStatus.ACSC;
                break;
            }
            case 8: {
                paymentStatus = PaymentStatus.RJCT;
                break;
            }
            case 9: {
                paymentStatus = PaymentStatus.RJCT;
                break;
            }
            default: {
                log.warn("unexpected payment status: " + hbciStatus.getStatus());
            }
        }
        return new PaymentStatusResponse(paymentStatus);
    }

    public InstantPaymentStatusJob(TransactionRequest<PaymentStatusReqest> paymentStatusReqest) {
        this.paymentStatusReqest = paymentStatusReqest;
    }
}

