/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.request.TransactionRequestFactory;
import de.adorsys.multibanking.domain.response.AccountInformationResponse;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.LoadAccounts;
import de.adorsys.multibanking.domain.transaction.LoadBalances;
import de.adorsys.multibanking.hbci.job.LoadBalancesJob;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVSEPAInfo;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountInformationJob
extends ScaAwareJob<LoadAccounts, AccountInformationResponse> {
    private static final Logger log = LoggerFactory.getLogger(AccountInformationJob.class);
    private final TransactionRequest<LoadAccounts> loadAccountInformationRequest;
    private AbstractHBCIJob sepaInfoJob;

    public AccountInformationJob(TransactionRequest<LoadAccounts> loadAccountInformationRequest) {
        this.loadAccountInformationRequest = loadAccountInformationRequest;
        if (((LoadAccounts)loadAccountInformationRequest.getTransaction()).isWithBalances()) {
            ((HbciConsent)loadAccountInformationRequest.getBankApiConsentData()).setCloseDialog(false);
        }
    }

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        if (!passport.jobSupported("SEPAInfo")) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, "SEPAInfo job not supported");
        }
        this.sepaInfoJob = new GVSEPAInfo((HBCIPassportInternal)passport);
        return this.sepaInfoJob;
    }

    @Override
    TransactionRequest<LoadAccounts> getTransactionRequest() {
        return this.loadAccountInformationRequest;
    }

    @Override
    String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        return GVSEPAInfo.getLowlevelName();
    }

    @Override
    public AccountInformationResponse createJobResponse(PinTanPassport passport, HbciTanSubmit tanSubmit) {
        this.loadAccountInformationRequest.getBankAccess().setBankName(passport.getInstName());
        List hbciAccounts = passport.getAccounts();
        List result = hbciAccounts.stream().map(konto -> {
            BankAccount bankAccount = accountStatementMapper.toBankAccount(konto);
            bankAccount.externalId(BankApi.HBCI, UUID.randomUUID().toString());
            bankAccount.bankName(this.loadAccountInformationRequest.getBankAccess().getBankName());
            if (this.sepaInfoJob.getJobResult().isOK() && ((LoadAccounts)this.loadAccountInformationRequest.getTransaction()).isWithBalances() && konto.allowedGVs.contains("HKSAL")) {
                LoadBalances loadBalances = new LoadBalances();
                loadBalances.setPsuAccount(bankAccount);
                TransactionRequest loadBalancesRequest = TransactionRequestFactory.create((AbstractTransaction)loadBalances, null, (BankAccess)this.loadAccountInformationRequest.getBankAccess(), (Bank)this.loadAccountInformationRequest.getBank(), (Object)this.loadAccountInformationRequest.getBankApiConsentData());
                new LoadBalancesJob((TransactionRequest<LoadBalances>)loadBalancesRequest).execute(null, this.dialog);
            }
            return bankAccount;
        }).collect(Collectors.toList());
        if (this.sepaInfoJob.getJobResult().isOK() && ((LoadAccounts)this.loadAccountInformationRequest.getTransaction()).isWithBalances()) {
            this.dialog.dialogEnd();
        }
        return AccountInformationResponse.builder().bankAccess(this.loadAccountInformationRequest.getBankAccess()).bankAccounts(result).build();
    }
}

