/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.RawSepaPayment;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVDauerSEPANew;
import org.kapott.hbci.GV.GVInstantUebSEPA;
import org.kapott.hbci.GV.GVRawSEPA;
import org.kapott.hbci.GV.GVUebSEPA;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.sepa.SepaVersion;

public class RawSepaJob
extends AbstractPaymentJob<RawSepaPayment> {
    private final TransactionRequest<RawSepaPayment> transactionRequest;
    private GVRawSEPA hbciRawSepaJob;

    @Override
    TransactionRequest<RawSepaPayment> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        return GVRawSEPA.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult jobResult) {
        return null;
    }

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        String jobName;
        RawSepaPayment sepaPayment = (RawSepaPayment)this.transactionRequest.getTransaction();
        switch (sepaPayment.getSepaTransactionType()) {
            case SINGLE_PAYMENT: {
                jobName = GVUebSEPA.getLowlevelName();
                break;
            }
            case INSTANT_PAYMENT: {
                jobName = GVInstantUebSEPA.getLowlevelName();
                break;
            }
            case BULK_PAYMENT: {
                jobName = "SammelUebSEPA";
                break;
            }
            case STANDING_ORDER: {
                jobName = GVDauerSEPANew.getLowlevelName();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported raw sepa transaction: " + sepaPayment.getSepaTransactionType());
            }
        }
        this.hbciRawSepaJob = new GVRawSEPA((HBCIPassportInternal)passport, jobName, sepaPayment.getRawRequestData());
        this.hbciRawSepaJob.setParam("src", this.getPsuKonto(passport));
        this.appendPainValues(sepaPayment, this.hbciRawSepaJob);
        this.hbciRawSepaJob.verifyConstraints();
        return this.hbciRawSepaJob;
    }

    @Override
    AbstractHBCIJob getHbciJob() {
        return this.hbciRawSepaJob;
    }

    private void appendPainValues(RawSepaPayment sepaPayment, GVRawSEPA sepagv) {
        String creditorIban = "";
        BigDecimal amount = new BigDecimal(0);
        String currency = "";
        List<Map<String, String>> result = this.parsePain(sepaPayment.getPainXml());
        for (Map<String, String> resultMap : result) {
            creditorIban = resultMap.get("dst.iban");
            amount = amount.add(NumberUtils.createBigDecimal((String)resultMap.get("value")));
            String tempCurrency = resultMap.get("curr");
            if (currency.length() > 0 && !currency.equals(tempCurrency)) {
                throw new IllegalArgumentException("mixed currencies in bulk payment");
            }
            currency = tempCurrency;
        }
        if (result.size() > 1) {
            sepagv.setLowlevelParam(sepagv.getName() + ".sepa.dst.iban", creditorIban);
        }
        sepagv.setLowlevelParam(sepagv.getName() + ".sepa.btg.value", amount.toString());
        sepagv.setLowlevelParam(sepagv.getName() + ".sepa.btg.curr", currency);
    }

    private List<Map<String, String>> parsePain(String painXml) {
        ArrayList<Map<String, String>> sepaResults = new ArrayList<Map<String, String>>();
        ISEPAParser parser = SEPAParserFactory.get((SepaVersion)SepaVersion.autodetect((String)painXml));
        try {
            parser.parse((InputStream)new ByteArrayInputStream(painXml.getBytes("ISO-8859-1")), sepaResults);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return sepaResults;
    }

    public RawSepaJob(TransactionRequest<RawSepaPayment> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

