/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.exception.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.LoadBalancesResponse;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.LoadBalances;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import java.util.List;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVSaldoReq;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancesJob
extends ScaAwareJob<LoadBalances, LoadBalancesResponse> {
    private static final Logger log = LoggerFactory.getLogger(LoadBalancesJob.class);
    private final TransactionRequest<LoadBalances> loadBalanceRequest;
    private AbstractHBCIJob balanceJob;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        this.balanceJob = new GVSaldoReq((HBCIPassportInternal)passport);
        this.balanceJob.setParam("my", this.getPsuKonto(passport));
        return this.balanceJob;
    }

    @Override
    TransactionRequest<LoadBalances> getTransactionRequest() {
        return this.loadBalanceRequest;
    }

    @Override
    String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        return GVSaldoReq.getLowlevelName();
    }

    @Override
    public LoadBalancesResponse createJobResponse(PinTanPassport passport, HbciTanSubmit tanSubmit, List<HBCIMsgStatus> msgStatusList) {
        if (this.balanceJob.getJobResult().getJobStatus().hasErrors()) {
            log.error("Balance job not OK");
            throw new MultibankingException(MultibankingError.HBCI_ERROR, this.balanceJob.getJobResult().getJobStatus().getErrorList().stream().map(messageString -> Message.builder().renderedMessage(messageString).build()).collect(Collectors.toList()));
        }
        BankAccount bankAccount = ((LoadBalances)this.loadBalanceRequest.getTransaction()).getPsuAccount();
        if (this.balanceJob.getJobResult().isOK()) {
            bankAccount.setBalances(accountStatementMapper.createBalancesReport((GVRSaldoReq)this.balanceJob.getJobResult(), bankAccount.getAccountNumber()));
        }
        return new LoadBalancesResponse(bankAccount);
    }

    public LoadBalancesJob(TransactionRequest<LoadBalances> loadBalanceRequest) {
        this.loadBalanceRequest = loadBalanceRequest;
    }
}

