/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.FutureSinglePayment;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTermUebSEPADel;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class DeleteFutureSinglePaymentJob
extends AbstractPaymentJob<FutureSinglePayment> {
    private final TransactionRequest<FutureSinglePayment> transactionRequest;
    private GVTermUebSEPADel hbciDeleteFutureSinglePaymentJob;
    private String jobName;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        FutureSinglePayment singlePayment = (FutureSinglePayment)this.transactionRequest.getTransaction();
        Konto src = this.getPsuKonto(passport);
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic();
        this.jobName = GVTermUebSEPADel.getLowlevelName();
        this.hbciDeleteFutureSinglePaymentJob = new GVTermUebSEPADel((HBCIPassportInternal)passport, this.jobName, null);
        this.hbciDeleteFutureSinglePaymentJob.setParam("orderid", singlePayment.getOrderId());
        this.hbciDeleteFutureSinglePaymentJob.setParam("date", singlePayment.getExecutionDate().toString());
        this.hbciDeleteFutureSinglePaymentJob.setParam("src", src);
        this.hbciDeleteFutureSinglePaymentJob.setParam("dst", dst);
        this.hbciDeleteFutureSinglePaymentJob.setParam("btg", new Value(singlePayment.getAmount(), singlePayment.getCurrency()));
        if (singlePayment.getPurpose() != null) {
            this.hbciDeleteFutureSinglePaymentJob.setParam("usage", singlePayment.getPurpose());
        }
        this.hbciDeleteFutureSinglePaymentJob.verifyConstraints();
        return this.hbciDeleteFutureSinglePaymentJob;
    }

    @Override
    AbstractHBCIJob getHbciJob() {
        return this.hbciDeleteFutureSinglePaymentJob;
    }

    @Override
    TransactionRequest<FutureSinglePayment> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    protected String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        return this.jobName;
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return null;
    }

    public DeleteFutureSinglePaymentJob(TransactionRequest<FutureSinglePayment> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

