/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.BulkPayment;
import de.adorsys.multibanking.domain.transaction.FutureBulkPayment;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.hbci.job.AbstractPaymentJob;
import org.apache.commons.lang3.BooleanUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVMultiUebSEPA;
import org.kapott.hbci.GV.GVTermMultiUebSEPA;
import org.kapott.hbci.GV_Result.GVRPayment;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class BulkPaymentJob
extends AbstractPaymentJob<BulkPayment> {
    private final TransactionRequest<BulkPayment> transactionRequest;
    private AbstractSEPAGV bulkPaymentHbciJob;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        BulkPayment bulkPayment = (BulkPayment)this.transactionRequest.getTransaction();
        Konto src = this.getPsuKonto(passport);
        if (bulkPayment instanceof FutureBulkPayment) {
            this.bulkPaymentHbciJob = new GVTermMultiUebSEPA((HBCIPassportInternal)passport, GVTermMultiUebSEPA.getLowlevelName());
            this.bulkPaymentHbciJob.setParam("date", ((FutureBulkPayment)bulkPayment).getExecutionDate().toString());
        } else {
            this.bulkPaymentHbciJob = new GVMultiUebSEPA((HBCIPassportInternal)passport, GVMultiUebSEPA.getLowlevelName());
        }
        this.bulkPaymentHbciJob.setParam("src", src);
        this.bulkPaymentHbciJob.setParam("batchbook", BooleanUtils.isTrue((Boolean)bulkPayment.getBatchbooking()) ? "1" : "0");
        for (int i = 0; i < bulkPayment.getPayments().size(); ++i) {
            SinglePayment payment = (SinglePayment)bulkPayment.getPayments().get(i);
            Konto dst = new Konto();
            dst.name = payment.getReceiver();
            dst.iban = payment.getReceiverIban();
            dst.bic = payment.getReceiverBic();
            this.bulkPaymentHbciJob.setParam("dst", Integer.valueOf(i), dst);
            this.bulkPaymentHbciJob.setParam("btg", Integer.valueOf(i), new Value(payment.getAmount(), payment.getCurrency()));
            if (payment.getPurpose() != null) {
                this.bulkPaymentHbciJob.setParam("usage", Integer.valueOf(i), payment.getPurpose());
            }
            if (payment.getPurposecode() == null) continue;
            this.bulkPaymentHbciJob.setParam("purposecode", Integer.valueOf(i), payment.getPurposecode());
        }
        this.bulkPaymentHbciJob.verifyConstraints();
        return this.bulkPaymentHbciJob;
    }

    @Override
    AbstractHBCIJob getHbciJob() {
        return this.bulkPaymentHbciJob;
    }

    @Override
    TransactionRequest<BulkPayment> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    protected String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        if (transactionType == AbstractTransaction.TransactionType.FUTURE_BULK_PAYMENT) {
            return "TermMultiUebSEPA";
        }
        return "MultiUebSEPA";
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return paymentGV instanceof GVRPayment ? ((GVRPayment)paymentGV).getOrderId() : null;
    }

    public BulkPaymentJob(TransactionRequest<BulkPayment> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

