/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AccountInformationResponse;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.LoadAccounts;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVSEPAInfo;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountInformationJob
extends ScaAwareJob<LoadAccounts, AccountInformationResponse> {
    private static final Logger log = LoggerFactory.getLogger(AccountInformationJob.class);
    private final TransactionRequest<LoadAccounts> loadAccountInformationRequest;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        if (!passport.jobSupported("SEPAInfo")) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, "SEPAInfo job not supported");
        }
        return new GVSEPAInfo((HBCIPassportInternal)passport);
    }

    @Override
    TransactionRequest<LoadAccounts> getTransactionRequest() {
        return this.loadAccountInformationRequest;
    }

    @Override
    String getHbciJobName(AbstractTransaction.TransactionType transactionType) {
        return GVSEPAInfo.getLowlevelName();
    }

    @Override
    public AccountInformationResponse createJobResponse(PinTanPassport passport, HbciTanSubmit tanSubmit, List<HBCIMsgStatus> msgStatusList) {
        this.loadAccountInformationRequest.getBankAccess().setBankName(passport.getInstName());
        ArrayList<BankAccount> hbciAccounts = new ArrayList<BankAccount>();
        for (Konto konto : passport.getAccounts()) {
            BankAccount bankAccount = accountStatementMapper.toBankAccount(konto);
            bankAccount.externalId(BankApi.HBCI, UUID.randomUUID().toString());
            bankAccount.bankName(this.loadAccountInformationRequest.getBankAccess().getBankName());
            hbciAccounts.add(bankAccount);
        }
        return AccountInformationResponse.builder().bankAccess(this.loadAccountInformationRequest.getBankAccess()).bankAccounts(hbciAccounts).build();
    }

    public AccountInformationJob(TransactionRequest<LoadAccounts> loadAccountInformationRequest) {
        this.loadAccountInformationRequest = loadAccountInformationRequest;
    }
}

