/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci;

import de.adorsys.multibanking.domain.request.AbstractRequest;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.hbci.HbciBpdUpdCallback;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class HbciCacheHandler {
    private static Map<String, Map<String, String>> bpdCache = new ConcurrentHashMap<String, Map<String, String>>();

    static HbciBpdUpdCallback setRequestBpdAndCreateCallback(AbstractRequest request) {
        String bankCode = Optional.ofNullable(request.getBank().getBankApiBankCode()).orElse(request.getBank().getBankCode());
        request.setHbciBPD(bpdCache.get(bankCode));
        return new HbciBpdUpdCallback(bankCode, bpdCache);
    }

    static void updateUpd(HbciBpdUpdCallback bpdUpdHbciCallback, AbstractResponse response) {
        Optional.ofNullable(bpdUpdHbciCallback).ifPresent(callback -> {
            response.setHbciUpd(callback.getUpd());
            response.setHbciSysId(callback.getSysId());
        });
    }

    private HbciCacheHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static Map<String, Map<String, String>> getBpdCache() {
        return bpdCache;
    }
}

