/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.EmptyResponse;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import java.util.Collections;
import java.util.List;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVUmbSEPA;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferJob
extends ScaRequiredJob<SinglePayment, EmptyResponse> {
    private static final Logger log = LoggerFactory.getLogger(TransferJob.class);
    private final TransactionRequest<SinglePayment> transactionRequest;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        SinglePayment singlePayment = (SinglePayment)this.transactionRequest.getTransaction();
        Konto src = this.getPsuKonto(passport);
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic();
        GVUmbSEPA sepagv = new GVUmbSEPA((HBCIPassportInternal)passport, GVUmbSEPA.getLowlevelName(), null);
        sepagv.setParam("src", src);
        sepagv.setParam("dst", dst);
        sepagv.setParam("btg", new Value(singlePayment.getAmount(), singlePayment.getCurrency()));
        if (singlePayment.getPurpose() != null) {
            sepagv.setParam("usage", singlePayment.getPurpose());
        }
        sepagv.verifyConstraints();
        return sepagv;
    }

    @Override
    public List<AbstractHBCIJob> createAdditionalMessages(PinTanPassport passport) {
        return Collections.emptyList();
    }

    @Override
    TransactionRequest<SinglePayment> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    String getHbciJobName(AbstractScaTransaction.TransactionType transactionType) {
        return GVUmbSEPA.getLowlevelName();
    }

    @Override
    EmptyResponse createJobResponse(PinTanPassport passport) {
        return new EmptyResponse();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult jobResult) {
        return null;
    }

    public TransferJob(TransactionRequest<SinglePayment> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

