/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.exception.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.response.SubmitAuthorizationCodeResponse;
import de.adorsys.multibanking.domain.transaction.SubmitAuthorisationCode;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciPassport;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.callback.AbstractHBCICallback;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.dialog.HBCIJobsDialog;
import org.kapott.hbci.manager.KnownTANProcess;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.status.HBCIStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitAuthorisationCodeJob<J extends ScaRequiredJob> {
    private static final Logger log = LoggerFactory.getLogger(SubmitAuthorisationCodeJob.class);
    private final J scaJob;

    public SubmitAuthorizationCodeResponse sumbitAuthorizationCode(SubmitAuthorisationCode submitAuthorisationCode) {
        HbciTanSubmit hbciTanSubmit = this.evaluateTanSubmit((HbciConsent)submitAuthorisationCode.getOriginTransactionRequest().getBankApiConsentData());
        HbciPassport hbciPassport = this.createPassport(submitAuthorisationCode, hbciTanSubmit);
        HBCIJobsDialog hbciDialog = new HBCIJobsDialog((PinTanPassport)hbciPassport, hbciTanSubmit.getDialogId(), hbciTanSubmit.getMsgNum());
        AbstractHBCIJob hbciJob = hbciTanSubmit.getTwoStepMechanism().getProcess() == 1 ? this.submitProcess1(hbciTanSubmit, hbciPassport, hbciDialog) : this.submitProcess2(hbciTanSubmit, hbciDialog);
        HBCIExecStatus hbciExecStatus = hbciDialog.execute(false);
        if (!hbciExecStatus.isOK()) {
            hbciDialog.dialogEnd();
            throw new MultibankingException(MultibankingError.HBCI_ERROR, hbciExecStatus.getErrorMessages().stream().map(messageString -> Message.builder().renderedMessage(messageString).build()).collect(Collectors.toList()));
        }
        if (hbciTanSubmit.getHbciJobName() != null && hbciTanSubmit.getHbciJobName().equals("HKIDN")) {
            SubmitAuthorizationCodeResponse response = new SubmitAuthorizationCodeResponse(((ScaRequiredJob)this.scaJob).authorisationAwareExecute(null, hbciDialog));
            response.setScaStatus(ScaStatus.FINALISED);
            response.setWarnings(this.warningStatusCodesToList(hbciExecStatus));
            return response;
        }
        return this.createResponse(hbciPassport, hbciTanSubmit, hbciJob, hbciExecStatus);
    }

    private AbstractHBCIJob submitProcess1(HbciTanSubmit hbciTanSubmit, HbciPassport hbciPassport, HBCIJobsDialog hbciDialog) {
        AbstractHBCIJob hbciJob = ((ScaRequiredJob)this.scaJob).createJobMessage(hbciPassport);
        if (hbciTanSubmit.getSepaPain() != null) {
            hbciJob.getConstraints().remove("_sepapain");
            hbciJob.setLowlevelParam(hbciJob.getName() + ".sepapain", hbciTanSubmit.getSepaPain());
        }
        hbciDialog.addTask(hbciJob);
        return hbciJob;
    }

    private AbstractHBCIJob submitProcess2(HbciTanSubmit hbciTanSubmit, HBCIJobsDialog hbciDialog) {
        AbstractHBCIJob originJob = Optional.ofNullable(hbciTanSubmit.getOriginJobName()).map(originJobName -> {
            AbstractHBCIJob result = ((ScaRequiredJob)this.scaJob).createJobMessage(hbciDialog.getPassport());
            try {
                result.setLlParams((Map)this.objectMapper().readValue(hbciTanSubmit.getLowLevelParams(), HashMap.class));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new MultibankingException(MultibankingError.INTERNAL_ERROR, 500, e.getMessage());
            }
            result.setSegVersion(hbciTanSubmit.getOriginSegVersion());
            return result;
        }).orElse(null);
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)hbciDialog.getPassport(), originJob);
        hktan.setProcess(KnownTANProcess.PROCESS2_STEP2);
        if (hktan.getLowlevelParam("TAN2Step" + hbciTanSubmit.getTwoStepMechanism().getSegversion() + "ordersegcode") == null) {
            hktan.setParam("ordersegcode", "HKIDN");
        }
        hktan.setParam("orderref", hbciTanSubmit.getOrderRef());
        hktan.setParam("process", hbciTanSubmit.getHktanProcess() != null ? hbciTanSubmit.getHktanProcess() : "2");
        hktan.setParam("notlasttan", "N");
        hbciDialog.addTask((AbstractHBCIJob)hktan, false);
        return originJob;
    }

    private SubmitAuthorizationCodeResponse<?> createResponse(PinTanPassport passport, HbciTanSubmit hbciTanSubmit, AbstractHBCIJob hbciJob, HBCIExecStatus status) {
        String transactionId = Optional.ofNullable(hbciJob).map(abstractHBCIJob -> this.orderIdFromJobResult(abstractHBCIJob.getJobResult())).orElse(hbciTanSubmit.getOrderRef());
        SubmitAuthorizationCodeResponse response = new SubmitAuthorizationCodeResponse(((ScaRequiredJob)this.scaJob).createJobResponse(passport));
        response.setTransactionId(transactionId);
        response.setWarnings(this.warningStatusCodesToList(status));
        ScaStatus scaStatus = Optional.ofNullable(hbciTanSubmit.getHbciJobName()).map(hbciJobName -> hbciJobName.equals("HKIDN") ? ScaStatus.FINALISED : ScaStatus.SCAMETHODSELECTED).orElse(ScaStatus.FINALISED);
        response.setScaStatus(scaStatus);
        return response;
    }

    private HbciTanSubmit evaluateTanSubmit(HbciConsent hbciConsent) {
        if (hbciConsent.getHbciTanSubmit() instanceof HbciTanSubmit) {
            return (HbciTanSubmit)hbciConsent.getHbciTanSubmit();
        }
        return this.deserializeTanSubmit((byte[])hbciConsent.getHbciTanSubmit());
    }

    private HbciTanSubmit deserializeTanSubmit(byte[] data) {
        try {
            return (HbciTanSubmit)this.objectMapper().readValue(data, HbciTanSubmit.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not deserialize HbciTanSubmit", e);
        }
    }

    private HbciPassport createPassport(final SubmitAuthorisationCode submitAuthorizationCode, HbciTanSubmit hbciTanSubmit) {
        Map bpd = Optional.ofNullable(submitAuthorizationCode.getOriginTransactionRequest().getHbciBPD()).orElseGet(() -> ((ScaRequiredJob)this.scaJob).fetchBpd(null).getBPD());
        HbciPassport.State state = HbciPassport.State.fromJson(hbciTanSubmit.getPassportState());
        HbciPassport hbciPassport = HbciDialogFactory.createPassport(state, (HBCICallback)new AbstractHBCICallback(){

            public String needTAN() {
                return ((HbciConsent)submitAuthorizationCode.getOriginTransactionRequest().getBankApiConsentData()).getScaAuthenticationData();
            }
        });
        state.apply(hbciPassport);
        HbciConsent hbciConsent = (HbciConsent)submitAuthorizationCode.getOriginTransactionRequest().getBankApiConsentData();
        hbciPassport.setPIN(hbciConsent.getCredentials().getPin());
        hbciPassport.setCurrentSecMechInfo(hbciTanSubmit.getTwoStepMechanism());
        hbciPassport.setBPD(bpd);
        return hbciPassport;
    }

    private ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.findAndRegisterModules();
        return objectMapper;
    }

    private String orderIdFromJobResult(HBCIJobResult jobResult) {
        return ((ScaRequiredJob)this.scaJob).orderIdFromJobResult(jobResult);
    }

    private List<String> warningStatusCodesToList(HBCIExecStatus hbciExecStatus) {
        return Optional.ofNullable(hbciExecStatus).map(HBCIExecStatus::getMsgStatusList).map(list -> list.isEmpty() ? null : (HBCIMsgStatus)list.get(0)).map(status -> status.segStatus).map(HBCIStatus::getWarnings).map(list -> list.stream().map(retVal -> retVal.code)).orElse(Stream.empty()).collect(Collectors.toList());
    }

    public SubmitAuthorisationCodeJob(J scaJob) {
        this.scaJob = scaJob;
    }
}

