/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.Booking;
import de.adorsys.multibanking.domain.exception.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.LoadBookingsResponse;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.LoadBookings;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVKUmsAll;
import org.kapott.hbci.GV.GVKUmsAllCamt;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Saldo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBookingsJob
extends ScaRequiredJob<LoadBookings, LoadBookingsResponse> {
    private static final Logger log = LoggerFactory.getLogger(LoadBookingsJob.class);
    private final TransactionRequest<LoadBookings> loadBookingsRequest;
    private AbstractHBCIJob bookingsJob;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        this.bookingsJob = this.createBookingsJob(passport);
        return this.bookingsJob;
    }

    @Override
    public List<AbstractHBCIJob> createAdditionalMessages(PinTanPassport passport) {
        return Collections.emptyList();
    }

    @Override
    TransactionRequest<LoadBookings> getTransactionRequest() {
        return this.loadBookingsRequest;
    }

    @Override
    String getHbciJobName(AbstractScaTransaction.TransactionType transactionType) {
        if (this.bookingsJob instanceof GVKUmsAllCamt) {
            return "KUmsAllCamt";
        }
        return "KUmsAll";
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult jobResult) {
        return null;
    }

    @Override
    public LoadBookingsResponse createJobResponse(PinTanPassport passport) {
        if (this.bookingsJob.getJobResult().getJobStatus().hasErrors()) {
            log.error("Bookings job not OK");
            throw new MultibankingException(MultibankingError.HBCI_ERROR, this.bookingsJob.getJobResult().getJobStatus().getErrorList().stream().map(messageString -> Message.builder().renderedMessage(messageString).build()).collect(Collectors.toList()));
        }
        List bookingList = null;
        BalancesReport balancesReport = null;
        List raw = null;
        GVRKUms bookingsResult = (GVRKUms)this.bookingsJob.getJobResult();
        if (((LoadBookings)this.loadBookingsRequest.getTransaction()).getRawResponseType() != null) {
            raw = bookingsResult.getRaw();
        } else {
            if (((LoadBookings)this.loadBookingsRequest.getTransaction()).isWithBalance() && !bookingsResult.getDataPerDay().isEmpty()) {
                GVRKUms.BTag lastBoookingDay = (GVRKUms.BTag)bookingsResult.getDataPerDay().get(bookingsResult.getDataPerDay().size() - 1);
                balancesReport = this.createBalancesReport(lastBoookingDay.end);
            }
            bookingList = accountStatementMapper.createBookings(bookingsResult).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Booking>(Comparator.comparing(Booking::getExternalId))), ArrayList::new));
        }
        return LoadBookingsResponse.builder().bookings(bookingList).balancesReport(balancesReport).rawData(raw).build();
    }

    private BalancesReport createBalancesReport(Saldo saldo) {
        BalancesReport balancesReport = new BalancesReport();
        balancesReport.setReadyBalance(accountStatementMapper.toBalance(saldo));
        return balancesReport;
    }

    private AbstractHBCIJob createBookingsJob(PinTanPassport passport) {
        AbstractHBCIJob hbciJob = this.createBookingsJobInternal(passport);
        hbciJob.setParam("my", this.getPsuKonto(passport));
        LocalDate dateFrom = Optional.ofNullable(((LoadBookings)this.loadBookingsRequest.getTransaction()).getDateFrom()).orElseGet(() -> this.getStartDate(passport.getJobRestrictions(hbciJob.getName())));
        hbciJob.setParam("startdate", Date.from(dateFrom.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        Optional.ofNullable(((LoadBookings)this.loadBookingsRequest.getTransaction()).getDateTo()).ifPresent(localDate -> hbciJob.setParam("enddate", Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant())));
        return hbciJob;
    }

    private AbstractHBCIJob createBookingsJobInternal(PinTanPassport passport) {
        LoadBookings.RawResponseType rawResponseType = ((LoadBookings)this.loadBookingsRequest.getTransaction()).getRawResponseType();
        if (rawResponseType != null && !passport.jobSupported(rawResponseType == LoadBookings.RawResponseType.CAMT ? GVKUmsAllCamt.getLowlevelName() : GVKUmsAll.getLowlevelName())) {
            throw new MultibankingException(MultibankingError.BOOKINGS_FORMAT_NOT_SUPPORTED, rawResponseType + " not supported");
        }
        return Optional.ofNullable(rawResponseType).map(format -> {
            if (format == LoadBookings.RawResponseType.CAMT) {
                return new GVKUmsAllCamt((HBCIPassportInternal)passport, true);
            }
            return new GVKUmsAll((HBCIPassportInternal)passport);
        }).orElseGet(() -> {
            if (passport.jobSupported(GVKUmsAllCamt.getLowlevelName())) {
                return new GVKUmsAllCamt((HBCIPassportInternal)passport, false);
            }
            if (passport.jobSupported(GVKUmsAll.getLowlevelName())) {
                return new GVKUmsAll((HBCIPassportInternal)passport);
            }
            throw new MultibankingException(MultibankingError.HBCI_ERROR, "transaction jobs not supported");
        });
    }

    private LocalDate getStartDate(Map<String, String> jobRestrictions) {
        LocalDate date;
        String days = jobRestrictions.get("timerange");
        if (days != null && days.length() > 0 && days.matches("[0-9]{1,4}")) {
            date = LocalDate.now().minusDays(Long.parseLong(days));
            log.info("earliest start date according to BPD: " + date.toString());
        } else {
            date = LocalDate.now().minusDays(90L);
        }
        return date;
    }

    public LoadBookingsJob(TransactionRequest<LoadBookings> loadBookingsRequest) {
        this.loadBookingsRequest = loadBookingsRequest;
    }
}

