/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.EmptyResponse;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.StandingOrder;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import de.adorsys.multibanking.hbci.model.HbciCycleMapper;
import java.util.Collections;
import java.util.List;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVDauerSEPADel;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteStandingOrderJob
extends ScaRequiredJob<StandingOrder, EmptyResponse> {
    private static final Logger log = LoggerFactory.getLogger(DeleteStandingOrderJob.class);
    private final TransactionRequest<StandingOrder> transactionRequest;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        StandingOrder standingOrder = (StandingOrder)this.transactionRequest.getTransaction();
        Konto src = this.getPsuKonto(passport);
        Konto dst = new Konto();
        dst.name = standingOrder.getOtherAccount().getOwner();
        dst.iban = standingOrder.getOtherAccount().getIban();
        dst.bic = standingOrder.getOtherAccount().getBic();
        GVDauerSEPADel gvDauerSEPADel = new GVDauerSEPADel((HBCIPassportInternal)passport);
        gvDauerSEPADel.setParam("src", src);
        gvDauerSEPADel.setParam("dst", dst);
        gvDauerSEPADel.setParam("btg", new Value(standingOrder.getAmount(), standingOrder.getCurrency()));
        gvDauerSEPADel.setParam("usage", standingOrder.getUsage());
        gvDauerSEPADel.setParam("orderid", standingOrder.getOrderId());
        if (standingOrder.getFirstExecutionDate() != null) {
            gvDauerSEPADel.setParam("firstdate", standingOrder.getFirstExecutionDate().toString());
        }
        if (standingOrder.getCycle() != null) {
            gvDauerSEPADel.setParam("timeunit", HbciCycleMapper.cycleToTimeunit(standingOrder.getCycle()));
            gvDauerSEPADel.setParam("turnus", HbciCycleMapper.cycleToTurnus(standingOrder.getCycle()));
        }
        gvDauerSEPADel.setParam("execday", standingOrder.getExecutionDay());
        if (standingOrder.getLastExecutionDate() != null) {
            gvDauerSEPADel.setParam("lastdate", standingOrder.getLastExecutionDate().toString());
        }
        gvDauerSEPADel.verifyConstraints();
        return gvDauerSEPADel;
    }

    @Override
    public List<AbstractHBCIJob> createAdditionalMessages(PinTanPassport passport) {
        return Collections.emptyList();
    }

    @Override
    EmptyResponse createJobResponse(PinTanPassport passport) {
        return new EmptyResponse();
    }

    @Override
    TransactionRequest<StandingOrder> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    protected String getHbciJobName(AbstractScaTransaction.TransactionType transactionType) {
        return GVDauerSEPADel.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return null;
    }

    public DeleteStandingOrderJob(TransactionRequest<StandingOrder> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

