/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import de.adorsys.multibanking.domain.Bank;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.Consent;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.exception.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.AbstractRequest;
import de.adorsys.multibanking.domain.request.AuthenticatePsuRequest;
import de.adorsys.multibanking.domain.request.SelectPsuAuthenticationMethodRequest;
import de.adorsys.multibanking.domain.request.TransactionAuthorisationRequest;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.request.UpdatePsuAuthenticationRequest;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.response.LoadAccountInformationResponse;
import de.adorsys.multibanking.domain.response.LoadBalancesResponse;
import de.adorsys.multibanking.domain.response.LoadBookingsResponse;
import de.adorsys.multibanking.domain.response.ScaMethodsResponse;
import de.adorsys.multibanking.domain.response.SubmitAuthorizationCodeResponse;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.domain.spi.StrongCustomerAuthorisable;
import de.adorsys.multibanking.domain.transaction.BulkPayment;
import de.adorsys.multibanking.domain.transaction.ForeignPayment;
import de.adorsys.multibanking.domain.transaction.FutureBulkPayment;
import de.adorsys.multibanking.domain.transaction.FutureSinglePayment;
import de.adorsys.multibanking.domain.transaction.LoadAccounts;
import de.adorsys.multibanking.domain.transaction.LoadBalances;
import de.adorsys.multibanking.domain.transaction.LoadBookings;
import de.adorsys.multibanking.domain.transaction.RawSepaPayment;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.domain.transaction.StandingOrder;
import de.adorsys.multibanking.domain.transaction.SubmitAuthorisationCode;
import de.adorsys.multibanking.hbci.HbciScaMapper;
import de.adorsys.multibanking.hbci.HbciScaMapperImpl;
import de.adorsys.multibanking.hbci.job.AccountInformationJob;
import de.adorsys.multibanking.hbci.job.BulkPaymentJob;
import de.adorsys.multibanking.hbci.job.DeleteFutureBulkPaymentJob;
import de.adorsys.multibanking.hbci.job.DeleteFutureSinglePaymentJob;
import de.adorsys.multibanking.hbci.job.DeleteStandingOrderJob;
import de.adorsys.multibanking.hbci.job.ForeignPaymentJob;
import de.adorsys.multibanking.hbci.job.LoadBalancesJob;
import de.adorsys.multibanking.hbci.job.LoadBookingsJob;
import de.adorsys.multibanking.hbci.job.NewStandingOrderJob;
import de.adorsys.multibanking.hbci.job.RawSepaJob;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import de.adorsys.multibanking.hbci.job.SinglePaymentJob;
import de.adorsys.multibanking.hbci.job.SubmitAuthorisationCodeJob;
import de.adorsys.multibanking.hbci.job.TanRequestJob;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciDialogRequest;
import de.adorsys.multibanking.hbci.model.HbciDialogRequestMapper;
import de.adorsys.multibanking.hbci.model.HbciDialogRequestMapperImpl;
import de.adorsys.multibanking.hbci.model.HbciDialogType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.iban4j.Iban;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTANMediaList;
import org.kapott.hbci.GV_Result.GVRTANMediaList;
import org.kapott.hbci.callback.AbstractHBCICallback;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.dialog.AbstractHbciDialog;
import org.kapott.hbci.dialog.HBCIJobsDialog;
import org.kapott.hbci.dialog.HBCIUpdDialog;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIVersion;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hbci4JavaBanking
implements OnlineBankingService {
    private static final Logger log = LoggerFactory.getLogger(Hbci4JavaBanking.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Map<String, Map<String, String>> bpdCache;
    private HbciScaMapper hbciScaMapper = new HbciScaMapperImpl();
    private HbciDialogRequestMapper hbciDialogRequestMapper = new HbciDialogRequestMapperImpl();

    public Hbci4JavaBanking() {
        this(null, false);
    }

    public Hbci4JavaBanking(boolean cacheBpdUpd) {
        this(null, cacheBpdUpd);
    }

    public Hbci4JavaBanking(InputStream customBankConfigInput, boolean cacheBpdUpd) {
        if (cacheBpdUpd) {
            this.bpdCache = new ConcurrentHashMap<String, Map<String, String>>();
        }
        try (InputStream inputStream = Optional.ofNullable(customBankConfigInput).orElseGet(this::getDefaultBanksInput);){
            HBCIUtils.refreshBLZList((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }

    private InputStream getDefaultBanksInput() {
        return Optional.ofNullable(HBCIUtils.class.getClassLoader().getResource("blz.properties")).map(url -> {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).orElseThrow(() -> new RuntimeException("blz.properties not exists in classpath"));
    }

    public BankApi bankApi() {
        return BankApi.HBCI;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(String userId) {
        return null;
    }

    public void removeUser(BankApiUser bankApiUser) {
    }

    private ScaMethodsResponse authenticatePsu(AuthenticatePsuRequest authenticatePsuRequest) {
        try {
            boolean withHktan;
            HbciDialogRequest dialogRequest = this.hbciDialogRequestMapper.toHbciDialogRequest((AbstractRequest)authenticatePsuRequest, null);
            BpdUpdHbciCallback hbciCallback = this.setRequestBpdAndCreateCallback(dialogRequest);
            dialogRequest.setCallback((HBCICallback)hbciCallback);
            HBCIExecStatus bpdExecStatus = this.fetchBpd(dialogRequest);
            boolean bl = withHktan = !bpdExecStatus.hasMessage("9400");
            if (!withHktan) {
                HbciConsent hbciConsent = (HbciConsent)authenticatePsuRequest.getBankApiConsentData();
                hbciConsent.setWithHktan(withHktan);
            }
            PinTanPassport passport = this.fetchUpd(dialogRequest, withHktan);
            Map<String, List<GVRTANMediaList.TANMediaInfo>> tanMediaMap = null;
            if (passport.jobSupported(GVTANMediaList.getLowlevelName())) {
                tanMediaMap = this.fetchTanMedias(dialogRequest, passport);
            }
            ScaMethodsResponse response = ScaMethodsResponse.builder().tanTransportTypes(this.extractTanTransportTypes(passport, tanMediaMap)).build();
            this.updateUpd(hbciCallback, (AbstractResponse)response);
            return response;
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public LoadAccountInformationResponse loadBankAccounts(TransactionRequest<LoadAccounts> request) {
        HbciConsent hbciConsent = (HbciConsent)request.getBankApiConsentData();
        try {
            if (hbciConsent.getHbciTanSubmit() == null || hbciConsent.getStatus() == ScaStatus.FINALISED) {
                this.checkBankExists(request.getBank());
                BpdUpdHbciCallback hbciCallback = this.setRequestBpdAndCreateCallback((AbstractRequest)request);
                AccountInformationJob accountInformationJob = new AccountInformationJob(request);
                LoadAccountInformationResponse response = (LoadAccountInformationResponse)accountInformationJob.authorisationAwareExecute((HBCICallback)hbciCallback);
                this.updateUpd(hbciCallback, (AbstractResponse)response);
                return response;
            }
            SubmitAuthorizationCodeResponse<? extends AbstractResponse> submitAuthorizationCodeResponse = this.submitAuthorizationCode(new SubmitAuthorisationCode(request));
            this.removeConsentTanSubmitData(hbciConsent, submitAuthorizationCodeResponse);
            return (LoadAccountInformationResponse)submitAuthorizationCodeResponse.getJobResponse();
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public LoadBookingsResponse loadBookings(TransactionRequest<LoadBookings> request) {
        HbciConsent hbciConsent = (HbciConsent)request.getBankApiConsentData();
        try {
            if (hbciConsent.getHbciTanSubmit() == null || hbciConsent.getStatus() == ScaStatus.FINALISED) {
                this.checkBankExists(request.getBank());
                BpdUpdHbciCallback hbciCallback = this.setRequestBpdAndCreateCallback((AbstractRequest)request);
                LoadBookingsJob loadBookingsJob = new LoadBookingsJob(request);
                LoadBookingsResponse response = (LoadBookingsResponse)loadBookingsJob.authorisationAwareExecute((HBCICallback)hbciCallback);
                this.updateUpd(hbciCallback, (AbstractResponse)response);
                return response;
            }
            SubmitAuthorizationCodeResponse<? extends AbstractResponse> submitAuthorizationCodeResponse = this.submitAuthorizationCode(new SubmitAuthorisationCode(request));
            this.removeConsentTanSubmitData(hbciConsent, submitAuthorizationCodeResponse);
            return (LoadBookingsResponse)submitAuthorizationCodeResponse.getJobResponse();
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public LoadBalancesResponse loadBalances(TransactionRequest<LoadBalances> request) {
        HbciConsent hbciConsent = (HbciConsent)request.getBankApiConsentData();
        try {
            if (hbciConsent.getHbciTanSubmit() == null || hbciConsent.getStatus() == ScaStatus.FINALISED) {
                this.checkBankExists(request.getBank());
                BpdUpdHbciCallback hbciCallback = this.setRequestBpdAndCreateCallback((AbstractRequest)request);
                LoadBalancesJob loadBalancesJob = new LoadBalancesJob(request);
                LoadBalancesResponse response = (LoadBalancesResponse)loadBalancesJob.authorisationAwareExecute((HBCICallback)hbciCallback);
                this.updateUpd(hbciCallback, (AbstractResponse)response);
                return response;
            }
            SubmitAuthorizationCodeResponse<? extends AbstractResponse> submitAuthorizationCodeResponse = this.submitAuthorizationCode(new SubmitAuthorisationCode(request));
            this.removeConsentTanSubmitData(hbciConsent, submitAuthorizationCodeResponse);
            return (LoadBalancesResponse)submitAuthorizationCodeResponse.getJobResponse();
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    private void removeConsentTanSubmitData(HbciConsent hbciConsent, SubmitAuthorizationCodeResponse<? extends AbstractResponse> submitAuthorizationCodeResponse) {
        hbciConsent.setHbciTanSubmit(null);
        hbciConsent.setStatus(submitAuthorizationCodeResponse.getScaStatus());
        hbciConsent.setScaAuthenticationData(null);
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public AuthorisationCodeResponse initiatePayment(TransactionRequest request) {
        this.checkBankExists(request.getBank());
        BpdUpdHbciCallback hbciCallback = this.setRequestBpdAndCreateCallback((AbstractRequest)request);
        try {
            ScaRequiredJob scaJob = Optional.ofNullable(request.getTransaction()).map(transaction -> this.createScaJob(request)).orElse(new TanRequestJob(request));
            Object response = scaJob.authorisationAwareExecute((HBCICallback)hbciCallback);
            this.updateUpd(hbciCallback, (AbstractResponse)response);
            return response.getAuthorisationCodeResponse();
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public SubmitAuthorizationCodeResponse<? extends AbstractResponse> submitAuthorizationCode(SubmitAuthorisationCode submitAuthorisationCode) {
        this.checkBankExists(submitAuthorisationCode.getOriginTransactionRequest().getBank());
        this.setRequestBpdAndCreateCallback((AbstractRequest)submitAuthorisationCode.getOriginTransactionRequest());
        try {
            ScaRequiredJob scaJob = this.createScaJob(submitAuthorisationCode.getOriginTransactionRequest());
            SubmitAuthorizationCodeResponse submitAuthorizationCodeResponse = new SubmitAuthorisationCodeJob<ScaRequiredJob>(scaJob).sumbitAuthorizationCode(submitAuthorisationCode);
            this.removeConsentTanSubmitData((HbciConsent)submitAuthorisationCode.getOriginTransactionRequest().getBankApiConsentData(), (SubmitAuthorizationCodeResponse<? extends AbstractResponse>)submitAuthorizationCodeResponse);
            return submitAuthorizationCodeResponse;
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public void removeBankAccount(BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    private void checkBankExists(Bank bank) {
        String bankCode = bank.getBankApiBankCode() != null ? bank.getBankApiBankCode() : bank.getBankCode();
        Optional.ofNullable(bank.getBankingUrl()).ifPresent(s -> {
            BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
            if (bankInfo == null) {
                bankInfo = new BankInfo();
                bankInfo.setBlz(bankCode);
                bankInfo.setPinTanAddress(s);
                bankInfo.setPinTanVersion(HBCIVersion.HBCI_300);
                HBCIUtils.addBankInfo((BankInfo)bankInfo);
            }
        });
    }

    private BpdUpdHbciCallback setRequestBpdAndCreateCallback(AbstractRequest request) {
        String bankCode = Optional.ofNullable(request.getBank().getBankApiBankCode()).orElse(request.getBank().getBankCode());
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> request.setHbciBPD((Map)cache.get(bankCode)));
        return new BpdUpdHbciCallback(bankCode, this.bpdCache);
    }

    public AbstractHbciDialog createDialog(HbciDialogType dialogType, HbciDialogRequest dialogRequest, HBCITwoStepMechanism twoStepMechanism) {
        this.checkBankExists(dialogRequest.getBank());
        String bankCode = dialogRequest.getBank().getBankApiBankCode() != null ? dialogRequest.getBank().getBankApiBankCode() : dialogRequest.getBank().getBankCode();
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> dialogRequest.setHbciBPD((Map)cache.get(bankCode)));
        try {
            return HbciDialogFactory.createDialog(dialogType, null, dialogRequest, twoStepMechanism);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    private HBCIExecStatus fetchBpd(HbciDialogRequest dialogRequest) {
        AbstractHbciDialog dialog = this.createDialog(HbciDialogType.BPD, dialogRequest, null);
        return dialog.execute(true);
    }

    private PinTanPassport fetchUpd(HbciDialogRequest dialogRequest, boolean withHktan) {
        HBCIUpdDialog dialog = (HBCIUpdDialog)this.createDialog(HbciDialogType.UPD, dialogRequest, null);
        dialog.setWithHktan(withHktan);
        dialog.execute(true);
        return dialog.getPassport();
    }

    private Map<String, List<GVRTANMediaList.TANMediaInfo>> fetchTanMedias(HbciDialogRequest dialogRequest, PinTanPassport passport) {
        List<HBCITwoStepMechanism> tanMediaNeededScaMethods = passport.getUserTwostepMechanisms().stream().filter(scaMethodId -> !scaMethodId.equals("999")).filter(scaMethodId -> {
            HBCITwoStepMechanism hbciTwoStepMechanismBpd = (HBCITwoStepMechanism)passport.getBankTwostepMechanisms().get(scaMethodId);
            return hbciTwoStepMechanismBpd != null && hbciTwoStepMechanismBpd.getNeedtanmedia().equals("2");
        }).map(scaMethod -> (HBCITwoStepMechanism)passport.getBankTwostepMechanisms().get(scaMethod)).collect(Collectors.toList());
        HashMap<String, List<GVRTANMediaList.TANMediaInfo>> tanMediaMap = new HashMap<String, List<GVRTANMediaList.TANMediaInfo>>();
        tanMediaNeededScaMethods.forEach(twoStepMechanism -> {
            GVTANMediaList gvtanMediaList = new GVTANMediaList((HBCIPassportInternal)passport);
            HBCIJobsDialog dialog = (HBCIJobsDialog)this.createDialog(HbciDialogType.JOBS, dialogRequest, (HBCITwoStepMechanism)twoStepMechanism);
            dialog.dialogInit(true, "HKTAB");
            dialog.addTask((AbstractHBCIJob)gvtanMediaList);
            dialog.execute(true);
            tanMediaMap.put(twoStepMechanism.getSecfunc(), ((GVRTANMediaList)gvtanMediaList.getJobResult()).mediaList());
        });
        return tanMediaMap;
    }

    public boolean bankSupported(String bankCode) {
        BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
        return bankInfo != null && bankInfo.getPinTanVersion() != null;
    }

    private ScaRequiredJob createScaJob(TransactionRequest transactionRequest) {
        switch (transactionRequest.getTransaction().getTransactionType()) {
            case SINGLE_PAYMENT: 
            case FUTURE_SINGLE_PAYMENT: {
                return new SinglePaymentJob((TransactionRequest<SinglePayment>)transactionRequest);
            }
            case FOREIGN_PAYMENT: {
                return new ForeignPaymentJob((TransactionRequest<ForeignPayment>)transactionRequest);
            }
            case BULK_PAYMENT: 
            case FUTURE_BULK_PAYMENT: {
                return new BulkPaymentJob((TransactionRequest<BulkPayment>)transactionRequest);
            }
            case STANDING_ORDER: {
                return new NewStandingOrderJob((TransactionRequest<StandingOrder>)transactionRequest);
            }
            case RAW_SEPA: {
                return new RawSepaJob((TransactionRequest<RawSepaPayment>)transactionRequest);
            }
            case FUTURE_SINGLE_PAYMENT_DELETE: {
                return new DeleteFutureSinglePaymentJob((TransactionRequest<FutureSinglePayment>)transactionRequest);
            }
            case FUTURE_BULK_PAYMENT_DELETE: {
                return new DeleteFutureBulkPaymentJob((TransactionRequest<FutureBulkPayment>)transactionRequest);
            }
            case STANDING_ORDER_DELETE: {
                return new DeleteStandingOrderJob((TransactionRequest<StandingOrder>)transactionRequest);
            }
            case TAN_REQUEST: {
                return new TanRequestJob(transactionRequest);
            }
            case LOAD_BANKACCOUNTS: {
                return new AccountInformationJob((TransactionRequest<LoadAccounts>)transactionRequest);
            }
            case LOAD_BALANCES: {
                return new LoadBalancesJob((TransactionRequest<LoadBalances>)transactionRequest);
            }
            case LOAD_TRANSACTIONS: {
                return new LoadBookingsJob((TransactionRequest<LoadBookings>)transactionRequest);
            }
        }
        throw new IllegalArgumentException("invalid transaction type " + transactionRequest.getTransaction().getTransactionType());
    }

    private RuntimeException handleHbciException(HBCI_Exception e) {
        Throwable processException = e;
        while (processException.getCause() != null && !(processException.getCause() instanceof MultibankingException)) {
            processException = processException.getCause();
        }
        if (processException.getCause() instanceof MultibankingException) {
            return (MultibankingException)processException.getCause();
        }
        return e;
    }

    private void updateUpd(BpdUpdHbciCallback bpdUpdHbciCallback, AbstractResponse response) {
        Optional.ofNullable(bpdUpdHbciCallback).ifPresent(callback -> {
            response.setHbciUpd(callback.getUpd());
            response.setHbciSysId(callback.getSysId());
        });
    }

    private List<TanTransportType> extractTanTransportTypes(PinTanPassport hbciPassport, Map<String, List<GVRTANMediaList.TANMediaInfo>> tanMediaMap) {
        return hbciPassport.getUserTwostepMechanisms().stream().map(id -> (HBCITwoStepMechanism)hbciPassport.getBankTwostepMechanisms().get(id)).filter(Objects::nonNull).map(hbciTwoStepMechanism -> TanTransportType.builder().id(hbciTwoStepMechanism.getSecfunc()).name(hbciTwoStepMechanism.getName()).inputInfo(hbciTwoStepMechanism.getInputinfo()).needTanMedia(hbciTwoStepMechanism.getNeedtanmedia().equals("2")).build()).map(tanTransportType -> {
            if (!tanTransportType.isNeedTanMedia()) {
                return Collections.singletonList(tanTransportType);
            }
            return ((List)tanMediaMap.get(tanTransportType.getId())).stream().map(tanMediaInfo -> {
                TanTransportType clone = (TanTransportType)SerializationUtils.clone((Serializable)tanTransportType);
                clone.setMedium(tanMediaInfo.mediaName);
                return clone;
            }).collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public StrongCustomerAuthorisable getStrongCustomerAuthorisation() {
        return new StrongCustomerAuthorisable(){

            public CreateConsentResponse createConsent(Consent consent, boolean redirectPreferred, String tppRedirectUri) {
                String bankCode = Iban.valueOf((String)consent.getPsuAccountIban()).getBankCode();
                if (!Hbci4JavaBanking.this.bankSupported(bankCode)) {
                    throw new MultibankingException(MultibankingError.BANK_NOT_SUPPORTED);
                }
                HbciConsent hbciConsent = new HbciConsent();
                hbciConsent.setStatus(ScaStatus.STARTED);
                return Hbci4JavaBanking.this.hbciScaMapper.toCreateConsentResponse(hbciConsent);
            }

            public Consent getConsent(String consentId) {
                return null;
            }

            public UpdateAuthResponse updatePsuAuthentication(UpdatePsuAuthenticationRequest updatePsuAuthentication) {
                HbciConsent hbciConsent = (HbciConsent)updatePsuAuthentication.getBankApiConsentData();
                hbciConsent.setCredentials(updatePsuAuthentication.getCredentials());
                AuthenticatePsuRequest request = Hbci4JavaBanking.this.hbciScaMapper.toAuthenticatePsuRequest(updatePsuAuthentication);
                ScaMethodsResponse response = Hbci4JavaBanking.this.authenticatePsu(request);
                hbciConsent.setTanMethodList(response.getTanTransportTypes());
                hbciConsent.setStatus(ScaStatus.PSUAUTHENTICATED);
                return Hbci4JavaBanking.this.hbciScaMapper.toUpdateAuthResponse(hbciConsent, Hbci4JavaBanking.this.bankApi());
            }

            public UpdateAuthResponse authorizeConsent(TransactionAuthorisationRequest transactionAuthorisation) {
                HbciConsent hbciConsent = (HbciConsent)transactionAuthorisation.getBankApiConsentData();
                hbciConsent.setScaAuthenticationData(transactionAuthorisation.getScaAuthenticationData());
                return Hbci4JavaBanking.this.hbciScaMapper.toUpdateAuthResponse(hbciConsent, Hbci4JavaBanking.this.bankApi());
            }

            public UpdateAuthResponse selectPsuAuthenticationMethod(SelectPsuAuthenticationMethodRequest selectPsuAuthenticationMethod) {
                HbciConsent hbciConsent = (HbciConsent)selectPsuAuthenticationMethod.getBankApiConsentData();
                TanTransportType selectedMethod = hbciConsent.getTanMethodList().stream().filter(tanTransportType -> tanTransportType.getId().equals(selectPsuAuthenticationMethod.getAuthenticationMethodId())).findFirst().orElseThrow(IllegalArgumentException::new);
                hbciConsent.setSelectedMethod(selectedMethod);
                hbciConsent.setStatus(ScaStatus.SCAMETHODSELECTED);
                return Hbci4JavaBanking.this.hbciScaMapper.toUpdateAuthResponse(hbciConsent, Hbci4JavaBanking.this.bankApi());
            }

            public void revokeConsent(String consentId) {
            }

            public UpdateAuthResponse getAuthorisationStatus(String consentId, String authorisationId, Object bankApiConsentData) {
                HbciConsent hbciConsent = (HbciConsent)bankApiConsentData;
                return Hbci4JavaBanking.this.hbciScaMapper.toUpdateAuthResponse(hbciConsent, Hbci4JavaBanking.this.bankApi());
            }

            public void validateConsent(String consentId, String authorisationId, ScaStatus expectedConsentStatus, Object bankApiConsentData) {
                HbciConsent hbciConsent = (HbciConsent)bankApiConsentData;
                if (hbciConsent.getHbciTanSubmit() != null && hbciConsent.getScaAuthenticationData() == null) {
                    throw new MultibankingException(MultibankingError.INVALID_CONSENT_STATUS);
                }
                if (hbciConsent.getStatus() == ScaStatus.SCAMETHODSELECTED || hbciConsent.getStatus() == ScaStatus.FINALISED) {
                    return;
                }
                throw new MultibankingException(MultibankingError.INVALID_CONSENT_STATUS);
            }

            public void afterExecute(Object bankApiConsentData, AuthorisationCodeResponse authorisationCodeResponse) {
                HbciConsent hbciConsent = (HbciConsent)bankApiConsentData;
                hbciConsent.setHbciTanSubmit(authorisationCodeResponse.getTanSubmit());
            }
        };
    }

    private static class BpdUpdHbciCallback
    extends AbstractHBCICallback {
        private final String bankCode;
        private final Map<String, Map<String, String>> bpdCache;
        private Map<String, String> upd;
        private String sysId;

        public void status(int statusTag, Object o) {
            if (statusTag == 4) {
                Optional.of(this.bpdCache).ifPresent(cache -> cache.put(this.bankCode, (Map)o));
            } else if (statusTag == 12) {
                this.upd = (Map)o;
            }
        }

        public void callback(int reason, List<String> messages, int datatype, StringBuilder retData) {
            if (reason == 40) {
                throw new MultibankingException(MultibankingError.INVALID_PIN, messages.stream().map(messageString -> Message.builder().renderedMessage(messageString).build()).collect(Collectors.toList()));
            }
        }

        public void status(int statusTag, Object[] o) {
            if (statusTag == 10) {
                this.sysId = o[1].toString();
            }
        }

        public BpdUpdHbciCallback(String bankCode, Map<String, Map<String, String>> bpdCache) {
            this.bankCode = bankCode;
            this.bpdCache = bpdCache;
        }

        public String getBankCode() {
            return this.bankCode;
        }

        public Map<String, Map<String, String>> getBpdCache() {
            return this.bpdCache;
        }

        public Map<String, String> getUpd() {
            return this.upd;
        }

        public String getSysId() {
            return this.sysId;
        }

        public void setUpd(Map<String, String> upd) {
            this.upd = upd;
        }

        public void setSysId(String sysId) {
            this.sysId = sysId;
        }

        public String toString() {
            return "Hbci4JavaBanking.BpdUpdHbciCallback(bankCode=" + this.getBankCode() + ", bpdCache=" + this.getBpdCache() + ", upd=" + this.getUpd() + ", sysId=" + this.getSysId() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BpdUpdHbciCallback)) {
                return false;
            }
            BpdUpdHbciCallback other = (BpdUpdHbciCallback)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            String this$bankCode = this.getBankCode();
            String other$bankCode = other.getBankCode();
            if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                return false;
            }
            Map<String, Map<String, String>> this$bpdCache = this.getBpdCache();
            Map<String, Map<String, String>> other$bpdCache = other.getBpdCache();
            if (this$bpdCache == null ? other$bpdCache != null : !((Object)this$bpdCache).equals(other$bpdCache)) {
                return false;
            }
            Map<String, String> this$upd = this.getUpd();
            Map<String, String> other$upd = other.getUpd();
            if (this$upd == null ? other$upd != null : !((Object)this$upd).equals(other$upd)) {
                return false;
            }
            String this$sysId = this.getSysId();
            String other$sysId = other.getSysId();
            return !(this$sysId == null ? other$sysId != null : !this$sysId.equals(other$sysId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BpdUpdHbciCallback;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bankCode = this.getBankCode();
            result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
            Map<String, Map<String, String>> $bpdCache = this.getBpdCache();
            result = result * 59 + ($bpdCache == null ? 43 : ((Object)$bpdCache).hashCode());
            Map<String, String> $upd = this.getUpd();
            result = result * 59 + ($upd == null ? 43 : ((Object)$upd).hashCode());
            String $sysId = this.getSysId();
            result = result * 59 + ($sysId == null ? 43 : $sysId.hashCode());
            return result;
        }
    }
}

