package de.adorsys.multibanking.hbci;

import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.request.AuthenticatePsuRequest;
import de.adorsys.multibanking.domain.request.UpdatePsuAuthenticationRequest;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-10-02T14:49:08+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_151 (Oracle Corporation)"
)
class HbciScaMapperImpl implements HbciScaMapper {

    @Override
    public CreateConsentResponse toCreateConsentResponse(HbciConsent bankApiConsentData) {
        if ( bankApiConsentData == null ) {
            return null;
        }

        CreateConsentResponse createConsentResponse = new CreateConsentResponse();

        createConsentResponse.setAuthorisationId( java.util.UUID.randomUUID().toString() );
        createConsentResponse.setBankApiConsentData( bankApiConsentData );
        createConsentResponse.setConsentId( java.util.UUID.randomUUID().toString() );

        return createConsentResponse;
    }

    @Override
    public UpdateAuthResponse toUpdateAuthResponse(HbciConsent hbciConsent, BankApi bankApi) {
        if ( hbciConsent == null && bankApi == null ) {
            return null;
        }

        UpdateAuthResponse updateAuthResponse = new UpdateAuthResponse();

        if ( hbciConsent != null ) {
            List<TanTransportType> list = hbciConsent.getTanMethodList();
            if ( list != null ) {
                updateAuthResponse.setScaMethods( new ArrayList<TanTransportType>( list ) );
            }
            updateAuthResponse.setScaStatus( hbciConsent.getStatus() );
        }
        if ( bankApi != null ) {
            updateAuthResponse.setBankApi( bankApi );
        }
        updateAuthResponse.setScaApproach( ScaApproach.EMBEDDED );

        return updateAuthResponse;
    }

    @Override
    public AuthenticatePsuRequest toAuthenticatePsuRequest(UpdatePsuAuthenticationRequest updatePsuAuthentication) {
        if ( updatePsuAuthentication == null ) {
            return null;
        }

        AuthenticatePsuRequest authenticatePsuRequest = new AuthenticatePsuRequest();

        authenticatePsuRequest.setBankApiUser( updatePsuAuthentication.getBankApiUser() );
        authenticatePsuRequest.setBankAccess( updatePsuAuthentication.getBankAccess() );
        authenticatePsuRequest.setBank( updatePsuAuthentication.getBank() );
        authenticatePsuRequest.setBankApiConsentData( updatePsuAuthentication.getBankApiConsentData() );
        authenticatePsuRequest.setHbciProduct( updatePsuAuthentication.getHbciProduct() );
        Map<String, String> map = updatePsuAuthentication.getHbciBPD();
        if ( map != null ) {
            authenticatePsuRequest.setHbciBPD( new HashMap<String, String>( map ) );
        }
        Map<String, String> map1 = updatePsuAuthentication.getHbciUPD();
        if ( map1 != null ) {
            authenticatePsuRequest.setHbciUPD( new HashMap<String, String>( map1 ) );
        }
        authenticatePsuRequest.setHbciSysId( updatePsuAuthentication.getHbciSysId() );
        authenticatePsuRequest.setPsuAccountIban( updatePsuAuthentication.getPsuAccountIban() );
        authenticatePsuRequest.setConsentId( updatePsuAuthentication.getConsentId() );

        return authenticatePsuRequest;
    }
}
