/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.ChallengeData;
import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.exception.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.AbstractRequest;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciDialogRequest;
import de.adorsys.multibanking.hbci.model.HbciDialogType;
import de.adorsys.multibanking.hbci.model.HbciObjectMapper;
import de.adorsys.multibanking.hbci.model.HbciObjectMapperImpl;
import de.adorsys.multibanking.hbci.model.HbciPassport;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.iban4j.Iban;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.callback.AbstractHBCICallback;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.dialog.AbstractHbciDialog;
import org.kapott.hbci.dialog.HBCIJobsDialog;
import org.kapott.hbci.manager.ChallengeInfo;
import org.kapott.hbci.manager.HBCIMessage;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.manager.KnownReturncode;
import org.kapott.hbci.manager.KnownTANProcess;
import org.kapott.hbci.manager.MatrixCode;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScaRequiredJob<T extends AbstractScaTransaction, R extends AbstractResponse> {
    private static final Logger log = LoggerFactory.getLogger(ScaRequiredJob.class);
    static HbciObjectMapper hbciObjectMapper = new HbciObjectMapperImpl();
    private HbciTanSubmit hbciTanSubmit = new HbciTanSubmit();
    private AuthorisationCodeResponse authorisationCodeResponse = new AuthorisationCodeResponse((Object)this.hbciTanSubmit);
    private HBCIJobsDialog dialog;

    public R authorisationAwareExecute(HBCICallback hbciCallback) {
        return this.authorisationAwareExecute(hbciCallback, null);
    }

    R authorisationAwareExecute(HBCICallback hbciCallback, HBCIJobsDialog existingDialog) {
        R jobResponse;
        this.dialog = existingDialog;
        if (this.dialog == null && (jobResponse = this.initDialog(hbciCallback)) != null) {
            return jobResponse;
        }
        AbstractHBCIJob hbciJob = this.createJobMessage(this.dialog.getPassport());
        boolean tan2StepRequired = hbciJob == null || this.dialog.getPassport().tan2StepRequired(hbciJob);
        GVTAN2Step hktan = null;
        if (tan2StepRequired) {
            hktan = this.prepareHbciMessagefor2FA(hbciJob);
        } else {
            this.dialog.addTask(hbciJob);
        }
        this.executeTasks((AbstractHbciDialog)this.dialog);
        tan2StepRequired = Optional.ofNullable(hktan).map(gvtan2Step -> KnownReturncode.W3076.searchReturnValue(gvtan2Step.getJobResult().getJobStatus().getRetVals()) == null && KnownReturncode.W3076.searchReturnValue(gvtan2Step.getJobResult().getGlobStatus().getRetVals()) == null).orElse(false);
        R jobResponse2 = this.createJobResponse(this.dialog.getPassport());
        if (tan2StepRequired) {
            this.updateTanSubmit(this.hbciTanSubmit, (AbstractHbciDialog)this.dialog, hbciJob);
            jobResponse2.setAuthorisationCodeResponse(this.authorisationCodeResponse);
        } else {
            this.dialog.close();
        }
        return jobResponse2;
    }

    private R initDialog(HBCICallback hbciCallback) {
        PinTanPassport bpdPassport = this.fetchBpd(hbciCallback);
        this.dialog = (HBCIJobsDialog)this.createDialog(HbciDialogType.JOBS, hbciCallback, this.getUserTanTransportType(bpdPassport.getBankTwostepMechanisms()));
        this.dialog.getPassport().setBPD(bpdPassport.getBPD());
        HBCIMsgStatus dialogInitMsgStatus = this.dialog.dialogInit(true);
        if (this.checkDialogInitScaRequired(dialogInitMsgStatus)) {
            R jobResponse = this.createJobResponse(this.dialog.getPassport());
            jobResponse.setAuthorisationCodeResponse(this.authorisationCodeResponse);
            return jobResponse;
        }
        return null;
    }

    private boolean checkDialogInitScaRequired(HBCIMsgStatus initMsgStatus) {
        if (!initMsgStatus.isOK()) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, initMsgStatus.getErrorList().stream().map(messageString -> Message.builder().renderedMessage(messageString).build()).collect(Collectors.toList()));
        }
        boolean scaRequired = initMsgStatus.segStatus.getRetVals().stream().anyMatch(hbciRetVal -> hbciRetVal.code.equals("0030"));
        if (scaRequired) {
            this.updateTanSubmit(this.hbciTanSubmit, (AbstractHbciDialog)this.dialog, this.createJobMessage(this.dialog.getPassport()));
            this.hbciTanSubmit.setHbciJobName("HKIDN");
            String header = "TAN2StepRes" + this.hbciTanSubmit.getTwoStepMechanism().getSegversion();
            this.dialog.getPassport().getCallback().tanChallengeCallback((String)initMsgStatus.getData().get(header + ".orderref"), (String)initMsgStatus.getData().get(header + ".challenge"), (String)initMsgStatus.getData().get(header + ".challenge_hhd_uc"), null);
        }
        return scaRequired;
    }

    PinTanPassport fetchBpd(HBCICallback hbciCallback) {
        AbstractHbciDialog dialog = this.createDialog(HbciDialogType.BPD, hbciCallback, null);
        dialog.execute(true);
        return dialog.getPassport();
    }

    private GVTAN2Step prepareHbciMessagefor2FA(AbstractHBCIJob hbciJob) {
        HBCITwoStepMechanism hbciTwoStepMechanism = this.getUserTanTransportType(this.dialog.getPassport().getBankTwostepMechanisms());
        if (hbciTwoStepMechanism.getProcess() == 1 && hbciJob == null) {
            throw new MultibankingException(MultibankingError.INTERNAL_ERROR, "Tan requests without corresponding transaction not supported with HKTAN process variant 1");
        }
        if (hbciJob == null || hbciTwoStepMechanism.getProcess() == 2) {
            return this.hktanProcess2(hbciTwoStepMechanism, hbciJob);
        }
        return this.hktanProcess1(hbciTwoStepMechanism, hbciJob);
    }

    private void updateTanSubmit(HbciTanSubmit hbciTanSubmit, AbstractHbciDialog dialog, AbstractHBCIJob scaJob) {
        hbciTanSubmit.setOriginJobName(Optional.ofNullable(this.getTransactionRequest().getTransaction()).map(transaction -> this.getHbciJobName(transaction.getTransactionType())).orElseGet(() -> this.getHbciJobName(null)));
        hbciTanSubmit.setPassportState(new HbciPassport.State(dialog.getPassport()).toJson());
        hbciTanSubmit.setDialogId(dialog.getDialogId());
        hbciTanSubmit.setMsgNum(dialog.getMsgnum());
        hbciTanSubmit.setTwoStepMechanism(this.getUserTanTransportType(dialog.getPassport().getBankTwostepMechanisms()));
        Optional.ofNullable(scaJob).ifPresent(hbciJob -> {
            try {
                hbciTanSubmit.setLowLevelParams(new ObjectMapper().writeValueAsString((Object)scaJob.getLowlevelParams()));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new MultibankingException(MultibankingError.INTERNAL_ERROR, 500, e.getMessage());
            }
            Optional.ofNullable(hbciJob.getPainVersion()).ifPresent(painVersion -> hbciTanSubmit.setPainVersion(painVersion.getURN()));
            hbciTanSubmit.setOriginLowLevelName(hbciJob.getJobName());
            hbciTanSubmit.setOriginSegVersion(hbciJob.getSegVersion());
            hbciTanSubmit.setHbciJobName(hbciJob.getHBCICode(false));
        });
    }

    private AbstractHbciDialog createDialog(HbciDialogType dialogType, HBCICallback hbciCallback, HBCITwoStepMechanism twoStepMechanism) {
        HBCICallback callback = this.createCallback(hbciCallback);
        HbciDialogRequest dialogRequest = this.createDialogRequest(callback);
        return HbciDialogFactory.createDialog(dialogType, null, dialogRequest, twoStepMechanism);
    }

    private void executeTasks(AbstractHbciDialog dialog) {
        HBCIExecStatus execStatus = dialog.execute(false);
        if (!execStatus.isOK()) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, execStatus.getErrorMessages().stream().map(messageString -> Message.builder().renderedMessage(messageString).build()).collect(Collectors.toList()));
        }
    }

    private GVTAN2Step hktanProcess1(HBCITwoStepMechanism hbciTwoStepMechanism, AbstractHBCIJob hbciJob) {
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)this.dialog.getPassport(), hbciJob);
        hktan.setProcess(KnownTANProcess.PROCESS1);
        hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
        if (this.dialog.getPassport().tanMediaNeeded()) {
            hktan.setParam("tanmedia", this.getConsent().getSelectedMethod().getMedium());
        }
        hktan.setParam("notlasttan", "N");
        hktan.setParam("orderhash", hbciJob.createOrderHash(hbciTwoStepMechanism.getSegversion()));
        if (StringUtils.equals((CharSequence)hbciTwoStepMechanism.getNeedchallengeklass(), (CharSequence)"J")) {
            ChallengeInfo cinfo = ChallengeInfo.getInstance();
            cinfo.applyParams(hbciJob, (AbstractHBCIJob)hktan, hbciTwoStepMechanism);
        }
        this.hbciTanSubmit.setSepaPain(hbciJob.getRawData());
        this.dialog.addTask((AbstractHBCIJob)hktan, false);
        return hktan;
    }

    private GVTAN2Step hktanProcess2(HBCITwoStepMechanism hbciTwoStepMechanism, AbstractHBCIJob hbciJob) {
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)this.dialog.getPassport(), hbciJob);
        hktan.setProcess(KnownTANProcess.PROCESS2_STEP1);
        hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
        if (this.dialog.getPassport().tanMediaNeeded()) {
            hktan.setParam("tanmedia", this.getConsent().getSelectedMethod().getMedium());
        }
        hktan.setParam("orderaccount", this.getPsuKonto(this.dialog.getPassport()));
        Optional.ofNullable(hbciJob).map(AbstractHBCIJob::getHBCICode).ifPresent(hbciCode -> hktan.setParam("ordersegcode", hbciCode));
        Optional<HBCIMessage> messages = Optional.ofNullable(hbciJob).map(arg_0 -> ((HBCIJobsDialog)this.dialog).addTask(arg_0));
        if (messages.isPresent()) {
            messages.get().append((AbstractHBCIJob)hktan);
        } else {
            this.dialog.addTask((AbstractHBCIJob)hktan);
        }
        return hktan;
    }

    Konto getPsuKonto(PinTanPassport passport) {
        return this.getPsuAccount().map(account -> {
            Konto konto = passport.findAccountByAccountNumber(Iban.valueOf((String)account.getIban()).getAccountNumber());
            konto.iban = account.getIban();
            konto.bic = Optional.ofNullable(account.getBic()).orElse(HBCIUtils.getBankInfo((String)konto.blz).getBic());
            return konto;
        }).orElseGet(() -> (Konto)passport.getAccounts().get(0));
    }

    private Optional<BankAccount> getPsuAccount() {
        return Optional.ofNullable(this.getTransactionRequest().getTransaction().getPsuAccount());
    }

    private HBCITwoStepMechanism getUserTanTransportType(Map<String, HBCITwoStepMechanism> bpdScaMethods) {
        return Optional.ofNullable(this.getConsent().getSelectedMethod()).map(tanTransportType -> (HBCITwoStepMechanism)bpdScaMethods.get(tanTransportType.getId())).map(hbciTwoStepMechanism -> {
            hbciTwoStepMechanism.setMedium(this.getConsent().getSelectedMethod().getMedium());
            return hbciTwoStepMechanism;
        }).orElseGet(() -> {
            HBCITwoStepMechanism hbciTwoStepMechanism = new HBCITwoStepMechanism();
            hbciTwoStepMechanism.setSecfunc("999");
            hbciTwoStepMechanism.setSegversion(6);
            hbciTwoStepMechanism.setProcess(2);
            hbciTwoStepMechanism.setId("999");
            return hbciTwoStepMechanism;
        });
    }

    private HBCICallback createCallback(final HBCICallback hbciCallback) {
        return new AbstractHBCICallback(){

            public void tanChallengeCallback(String orderRef, String challenge, String challengeHhdUc, HHDVersion.Type type) {
                ScaRequiredJob.this.hbciTanSubmit.setOrderRef(orderRef);
                if (challenge != null) {
                    ChallengeData challengeData = new ChallengeData();
                    challengeData.setAdditionalInformation(challenge);
                    if (challengeHhdUc != null) {
                        try {
                            byte[] image = new MatrixCode(challengeHhdUc).getImage();
                            challengeData.setImage(new String(image, StandardCharsets.UTF_8));
                        }
                        catch (Exception e) {
                            challengeData.setData(Collections.singletonList(challengeHhdUc));
                        }
                    }
                    UpdateAuthResponse updateAuthResponse = new UpdateAuthResponse();
                    updateAuthResponse.setBankApi(BankApi.HBCI);
                    updateAuthResponse.setScaStatus(ScaStatus.SCAMETHODSELECTED);
                    updateAuthResponse.setScaApproach(ScaApproach.EMBEDDED);
                    updateAuthResponse.setChallenge(challengeData);
                    ScaRequiredJob.this.authorisationCodeResponse.setUpdateAuthResponse(updateAuthResponse);
                }
            }

            public void status(int statusTag, Object o) {
                Optional.ofNullable(hbciCallback).ifPresent(callback -> callback.status(statusTag, o));
            }

            public void status(int statusTag, Object[] o) {
                Optional.ofNullable(hbciCallback).ifPresent(callback -> callback.status(statusTag, o));
            }
        };
    }

    private HbciDialogRequest createDialogRequest(HBCICallback hbciCallback) {
        return hbciObjectMapper.toHbciDialogRequest((AbstractRequest)this.getTransactionRequest(), hbciCallback);
    }

    private HbciConsent getConsent() {
        return (HbciConsent)this.getTransactionRequest().getBankApiConsentData();
    }

    public abstract AbstractHBCIJob createJobMessage(PinTanPassport var1);

    public abstract List<AbstractHBCIJob> createAdditionalMessages(PinTanPassport var1);

    abstract TransactionRequest<T> getTransactionRequest();

    abstract String getHbciJobName(AbstractScaTransaction.TransactionType var1);

    abstract R createJobResponse(PinTanPassport var1);

    public abstract String orderIdFromJobResult(HBCIJobResult var1);
}

