/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.EmptyResponse;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.BulkPayment;
import de.adorsys.multibanking.domain.transaction.FutureBulkPayment;
import de.adorsys.multibanking.domain.transaction.SinglePayment;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVMultiUebSEPA;
import org.kapott.hbci.GV.GVTermMultiUebSEPA;
import org.kapott.hbci.GV_Result.GVRTermUeb;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class BulkPaymentJob
extends ScaRequiredJob<BulkPayment, EmptyResponse> {
    private final TransactionRequest<BulkPayment> transactionRequest;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        GVTermMultiUebSEPA sepagv;
        BulkPayment bulkPayment = (BulkPayment)this.transactionRequest.getTransaction();
        Konto src = this.getPsuKonto(passport);
        if (bulkPayment instanceof FutureBulkPayment) {
            sepagv = new GVTermMultiUebSEPA((HBCIPassportInternal)passport, GVTermMultiUebSEPA.getLowlevelName());
            sepagv.setParam("date", ((FutureBulkPayment)bulkPayment).getExecutionDate().toString());
        } else {
            sepagv = new GVMultiUebSEPA((HBCIPassportInternal)passport, GVMultiUebSEPA.getLowlevelName());
        }
        sepagv.setParam("src", src);
        sepagv.setParam("batchbook", BooleanUtils.isTrue((Boolean)bulkPayment.getBatchbooking()) ? "1" : "0");
        for (int i = 0; i < bulkPayment.getPayments().size(); ++i) {
            SinglePayment payment = (SinglePayment)bulkPayment.getPayments().get(i);
            Konto dst = new Konto();
            dst.name = payment.getReceiver();
            dst.iban = payment.getReceiverIban();
            dst.bic = payment.getReceiverBic();
            sepagv.setParam("dst", Integer.valueOf(i), dst);
            sepagv.setParam("btg", Integer.valueOf(i), new Value(payment.getAmount(), payment.getCurrency()));
            if (payment.getPurpose() != null) {
                sepagv.setParam("usage", Integer.valueOf(i), payment.getPurpose());
            }
            if (payment.getPurposecode() == null) continue;
            sepagv.setParam("purposecode", Integer.valueOf(i), payment.getPurposecode());
        }
        sepagv.verifyConstraints();
        return sepagv;
    }

    @Override
    public List<AbstractHBCIJob> createAdditionalMessages(PinTanPassport passport) {
        return Collections.emptyList();
    }

    @Override
    EmptyResponse createJobResponse(PinTanPassport passport) {
        return new EmptyResponse();
    }

    @Override
    TransactionRequest<BulkPayment> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    protected String getHbciJobName(AbstractScaTransaction.TransactionType transactionType) {
        if (transactionType == AbstractScaTransaction.TransactionType.FUTURE_BULK_PAYMENT) {
            return "TermMultiUebSEPA";
        }
        return "MultiUebSEPA";
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return paymentGV instanceof GVRTermUeb ? ((GVRTermUeb)paymentGV).getOrderId() : null;
    }

    public BulkPaymentJob(TransactionRequest<BulkPayment> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

