/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.LoadAccountInformationResponse;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.LoadAccounts;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVSEPAInfo;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountInformationJob
extends ScaRequiredJob<LoadAccounts, LoadAccountInformationResponse> {
    private static final Logger log = LoggerFactory.getLogger(AccountInformationJob.class);
    private final TransactionRequest<LoadAccounts> loadAccountInformationRequest;
    private List<BankAccount> hbciAccounts;

    @Override
    public AbstractHBCIJob createJobMessage(PinTanPassport passport) {
        if (!passport.jobSupported("SEPAInfo")) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, "SEPAInfo job not supported");
        }
        return new GVSEPAInfo((HBCIPassportInternal)passport);
    }

    @Override
    public List<AbstractHBCIJob> createAdditionalMessages(PinTanPassport passport) {
        return Collections.emptyList();
    }

    @Override
    TransactionRequest<LoadAccounts> getTransactionRequest() {
        return this.loadAccountInformationRequest;
    }

    @Override
    String getHbciJobName(AbstractScaTransaction.TransactionType transactionType) {
        return GVSEPAInfo.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult jobResult) {
        return null;
    }

    @Override
    public LoadAccountInformationResponse createJobResponse(PinTanPassport passport) {
        this.loadAccountInformationRequest.getBankAccess().setBankName(passport.getInstName());
        this.hbciAccounts = new ArrayList<BankAccount>();
        for (Konto konto : passport.getAccounts()) {
            BankAccount bankAccount = hbciObjectMapper.toBankAccount(konto);
            bankAccount.externalId(BankApi.HBCI, UUID.randomUUID().toString());
            bankAccount.bankName(this.loadAccountInformationRequest.getBankAccess().getBankName());
            this.hbciAccounts.add(bankAccount);
        }
        return LoadAccountInformationResponse.builder().bankAccess(this.loadAccountInformationRequest.getBankAccess()).bankAccounts(this.hbciAccounts).build();
    }

    public TransactionRequest<LoadAccounts> getLoadAccountInformationRequest() {
        return this.loadAccountInformationRequest;
    }

    public List<BankAccount> getHbciAccounts() {
        return this.hbciAccounts;
    }

    public void setHbciAccounts(List<BankAccount> hbciAccounts) {
        this.hbciAccounts = hbciAccounts;
    }

    public String toString() {
        return "AccountInformationJob(loadAccountInformationRequest=" + this.getLoadAccountInformationRequest() + ", hbciAccounts=" + this.getHbciAccounts() + ")";
    }

    public AccountInformationJob(TransactionRequest<LoadAccounts> loadAccountInformationRequest) {
        this.loadAccountInformationRequest = loadAccountInformationRequest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountInformationJob)) {
            return false;
        }
        AccountInformationJob other = (AccountInformationJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransactionRequest<LoadAccounts> this$loadAccountInformationRequest = this.getLoadAccountInformationRequest();
        TransactionRequest<LoadAccounts> other$loadAccountInformationRequest = other.getLoadAccountInformationRequest();
        if (this$loadAccountInformationRequest == null ? other$loadAccountInformationRequest != null : !this$loadAccountInformationRequest.equals(other$loadAccountInformationRequest)) {
            return false;
        }
        List<BankAccount> this$hbciAccounts = this.getHbciAccounts();
        List<BankAccount> other$hbciAccounts = other.getHbciAccounts();
        return !(this$hbciAccounts == null ? other$hbciAccounts != null : !((Object)this$hbciAccounts).equals(other$hbciAccounts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountInformationJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionRequest<LoadAccounts> $loadAccountInformationRequest = this.getLoadAccountInformationRequest();
        result = result * 59 + ($loadAccountInformationRequest == null ? 43 : $loadAccountInformationRequest.hashCode());
        List<BankAccount> $hbciAccounts = this.getHbciAccounts();
        result = result * 59 + ($hbciAccounts == null ? 43 : ((Object)$hbciAccounts).hashCode());
        return result;
    }
}

