package de.adorsys.multibanking.hbci.model;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.Balance.BalanceBuilder;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.Booking;
import de.adorsys.multibanking.domain.request.AbstractRequest;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import org.kapott.hbci.GV_Result.GVRKUms.UmsLine;
import org.kapott.hbci.GV_Result.GVRSaldoReq.Info;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-09-30T12:50:27+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_151 (Oracle Corporation)"
)
public class HbciObjectMapperImpl implements HbciObjectMapper {

    @Override
    public HbciDialogRequest toHbciDialogRequest(AbstractRequest transactionRequest, HBCICallback callback) {
        if ( transactionRequest == null && callback == null ) {
            return null;
        }

        HbciDialogRequest hbciDialogRequest = new HbciDialogRequest();

        if ( transactionRequest != null ) {
            hbciDialogRequest.setBankApiUser( transactionRequest.getBankApiUser() );
            hbciDialogRequest.setBankAccess( transactionRequest.getBankAccess() );
            hbciDialogRequest.setBank( transactionRequest.getBank() );
            hbciDialogRequest.setBankApiConsentData( transactionRequest.getBankApiConsentData() );
            hbciDialogRequest.setHbciProduct( transactionRequest.getHbciProduct() );
            Map<String, String> map = transactionRequest.getHbciBPD();
            if ( map != null ) {
                hbciDialogRequest.setHbciBPD( new HashMap<String, String>( map ) );
            }
            Map<String, String> map1 = transactionRequest.getHbciUPD();
            if ( map1 != null ) {
                hbciDialogRequest.setHbciUPD( new HashMap<String, String>( map1 ) );
            }
            hbciDialogRequest.setHbciSysId( transactionRequest.getHbciSysId() );
        }
        if ( callback != null ) {
            hbciDialogRequest.setCallback( callback );
        }

        return hbciDialogRequest;
    }

    @Override
    public BalancesReport toBalancesReport(Info saldoInfo) {
        if ( saldoInfo == null ) {
            return null;
        }

        BalancesReport balancesReport = new BalancesReport();

        balancesReport.setUnreadyBalance( toBalance( saldoInfo.unready ) );
        balancesReport.setReadyBalance( toBalance( saldoInfo.ready ) );
        balancesReport.setUsedBalance( toBalance( saldoInfo.used ) );
        balancesReport.setAvailableBalance( toBalance( saldoInfo.available ) );
        balancesReport.setCreditBalance( toBalance( saldoInfo.kredit ) );

        return balancesReport;
    }

    @Override
    public Balance toBalance(Value value) {
        if ( value == null ) {
            return null;
        }

        BalanceBuilder balance = Balance.builder();

        balance.amount( value.getBigDecimalValue() );
        balance.currency( value.getCurr() );

        return balance.build();
    }

    @Override
    public Balance toBalance(Saldo saldo) {
        if ( saldo == null ) {
            return null;
        }

        BalanceBuilder balance = Balance.builder();

        if ( saldo.timestamp != null ) {
            balance.date( LocalDateTime.ofInstant( saldo.timestamp.toInstant(), ZoneOffset.UTC ).toLocalDate() );
        }
        balance.amount( saldoValueBigDecimalValue( saldo ) );
        balance.currency( saldoValueCurr( saldo ) );

        return balance.build();
    }

    @Override
    public BankAccount toBankAccount(Konto konto) {
        if ( konto == null ) {
            return null;
        }

        BankAccount bankAccount = new BankAccount();

        bankAccount.setName( konto.type );
        bankAccount.setCurrency( konto.curr );
        bankAccount.setAccountNumber( konto.number );
        bankAccount.setCountry( konto.country );
        bankAccount.setBlz( konto.blz );
        bankAccount.setBic( konto.bic );
        bankAccount.setIban( konto.iban );

        bankAccount.setOwner( (konto.name + (konto.name2 != null ? konto.name2 : "")).trim() );
        bankAccount.setType( de.adorsys.multibanking.domain.BankAccountType.fromHbciType(org.apache.commons.lang3.math.NumberUtils.toInt(konto.acctype)) );

        return bankAccount;
    }

    @Override
    public Booking toBooking(UmsLine line) {
        if ( line == null ) {
            return null;
        }

        Booking booking = new Booking();

        booking.setAmount( lineValueBigDecimalValue( line ) );
        if ( line.valuta != null ) {
            booking.setValutaDate( LocalDateTime.ofInstant( line.valuta.toInstant(), ZoneOffset.UTC ).toLocalDate() );
        }
        booking.setTransactionCode( line.purposecode );
        booking.setReversal( line.storno );
        booking.setBalance( lineSaldoValueBigDecimalValue( line ) );
        if ( line.bdate != null ) {
            booking.setBookingDate( LocalDateTime.ofInstant( line.bdate.toInstant(), ZoneOffset.UTC ).toLocalDate() );
        }
        booking.setCurrency( lineValueCurr( line ) );
        booking.setOrigValue( lineOrig_valueBigDecimalValue( line ) );
        booking.setChargeValue( lineCharge_valueBigDecimalValue( line ) );
        booking.setCustomerRef( line.customerRef );
        booking.setInstRef( line.instRef );
        booking.setText( line.text );
        booking.setAdditional( line.additional );
        booking.setPrimanota( line.primanota );
        booking.setAddkey( line.addkey );
        booking.setSepa( line.sepa );
        booking.setCamt( line.camt );

        booking.setUsage( getUsage(line.usage.size() > 0 ? line.usage : splitEqually(line.additional, 27)) );
        booking.setExternalId( "B-" + line.valuta.getTime() + "_" + line.value.getLongValue() + "_" + line.saldo.value.getLongValue() );
        booking.setMandateReference( de.adorsys.multibanking.domain.utils.Utils.extractMandateReference(booking.getUsage()) );
        booking.setBankApi( BankApi.HBCI );
        booking.setCreditorId( de.adorsys.multibanking.domain.utils.Utils.extractCreditorId(booking.getUsage()) );

        return booking;
    }

    private BigDecimal saldoValueBigDecimalValue(Saldo saldo) {
        if ( saldo == null ) {
            return null;
        }
        Value value = saldo.value;
        if ( value == null ) {
            return null;
        }
        BigDecimal bigDecimalValue = value.getBigDecimalValue();
        if ( bigDecimalValue == null ) {
            return null;
        }
        return bigDecimalValue;
    }

    private String saldoValueCurr(Saldo saldo) {
        if ( saldo == null ) {
            return null;
        }
        Value value = saldo.value;
        if ( value == null ) {
            return null;
        }
        String curr = value.getCurr();
        if ( curr == null ) {
            return null;
        }
        return curr;
    }

    private BigDecimal lineValueBigDecimalValue(UmsLine umsLine) {
        if ( umsLine == null ) {
            return null;
        }
        Value value = umsLine.value;
        if ( value == null ) {
            return null;
        }
        BigDecimal bigDecimalValue = value.getBigDecimalValue();
        if ( bigDecimalValue == null ) {
            return null;
        }
        return bigDecimalValue;
    }

    private BigDecimal lineSaldoValueBigDecimalValue(UmsLine umsLine) {
        if ( umsLine == null ) {
            return null;
        }
        Saldo saldo = umsLine.saldo;
        if ( saldo == null ) {
            return null;
        }
        Value value = saldo.value;
        if ( value == null ) {
            return null;
        }
        BigDecimal bigDecimalValue = value.getBigDecimalValue();
        if ( bigDecimalValue == null ) {
            return null;
        }
        return bigDecimalValue;
    }

    private String lineValueCurr(UmsLine umsLine) {
        if ( umsLine == null ) {
            return null;
        }
        Value value = umsLine.value;
        if ( value == null ) {
            return null;
        }
        String curr = value.getCurr();
        if ( curr == null ) {
            return null;
        }
        return curr;
    }

    private BigDecimal lineOrig_valueBigDecimalValue(UmsLine umsLine) {
        if ( umsLine == null ) {
            return null;
        }
        Value orig_value = umsLine.orig_value;
        if ( orig_value == null ) {
            return null;
        }
        BigDecimal bigDecimalValue = orig_value.getBigDecimalValue();
        if ( bigDecimalValue == null ) {
            return null;
        }
        return bigDecimalValue;
    }

    private BigDecimal lineCharge_valueBigDecimalValue(UmsLine umsLine) {
        if ( umsLine == null ) {
            return null;
        }
        Value charge_value = umsLine.charge_value;
        if ( charge_value == null ) {
            return null;
        }
        BigDecimal bigDecimalValue = charge_value.getBigDecimalValue();
        if ( bigDecimalValue == null ) {
            return null;
        }
        return bigDecimalValue;
    }
}
