/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.domain.exception.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.response.SubmitAuthorizationCodeResponse;
import de.adorsys.multibanking.domain.transaction.SubmitAuthorisationCode;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import de.adorsys.multibanking.hbci.model.HBCIConsent;
import de.adorsys.multibanking.hbci.model.HbciCallback;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciPassport;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIJobFactory;
import org.kapott.hbci.manager.KnownTANProcess;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitAuthorisationCodeJob<J extends ScaRequiredJob> {
    private static final Logger log = LoggerFactory.getLogger(SubmitAuthorisationCodeJob.class);
    private final J scaJob;

    public SubmitAuthorizationCodeResponse sumbitAuthorizationCode(SubmitAuthorisationCode submitAuthorisationCode) {
        HbciTanSubmit hbciTanSubmit = this.evaluateTanSubmit((HBCIConsent)submitAuthorisationCode.getOriginTransactionRequest().getBankApiConsentData());
        HbciPassport hbciPassport = this.createPassport(submitAuthorisationCode, hbciTanSubmit);
        HBCIDialog hbciDialog = new HBCIDialog((PinTanPassport)hbciPassport, hbciTanSubmit.getDialogId(), hbciTanSubmit.getMsgNum());
        AbstractHBCIJob hbciJob = hbciTanSubmit.getTwoStepMechanism().getProcess() == 1 ? this.submitProcess1(hbciTanSubmit, hbciPassport, hbciDialog) : this.submitProcess2(hbciTanSubmit, hbciDialog);
        HBCIExecStatus status = hbciDialog.execute(true);
        if (!status.isOK()) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, status.getDialogStatus().getErrorMessages().stream().map(messageString -> Message.builder().renderedMessage(messageString).build()).collect(Collectors.toList()));
        }
        return this.createResponse(hbciPassport, hbciTanSubmit, hbciJob, status);
    }

    private AbstractHBCIJob submitProcess1(HbciTanSubmit hbciTanSubmit, HbciPassport hbciPassport, HBCIDialog hbciDialog) {
        AbstractHBCIJob hbciJob = ((ScaRequiredJob)this.scaJob).createScaMessage(hbciPassport);
        if (hbciTanSubmit.getSepaPain() != null) {
            hbciJob.getConstraints().remove("_sepapain");
            hbciJob.setLowlevelParam(hbciJob.getName() + ".sepapain", hbciTanSubmit.getSepaPain());
        }
        hbciDialog.addTask(hbciJob);
        return hbciJob;
    }

    private AbstractHBCIJob submitProcess2(HbciTanSubmit hbciTanSubmit, HBCIDialog hbciDialog) {
        AbstractHBCIJob originJob = Optional.ofNullable(hbciTanSubmit.getOriginJobName()).map(s -> {
            AbstractHBCIJob result = HBCIJobFactory.newJob((String)hbciTanSubmit.getOriginJobName(), (HBCIPassportInternal)hbciDialog.getPassport());
            try {
                result.setLlParams((Map)this.objectMapper().readValue(hbciTanSubmit.getLowLevelParams(), HashMap.class));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new MultibankingException(MultibankingError.INTERNAL_ERROR, 500, e.getMessage());
            }
            result.setSegVersion(hbciTanSubmit.getOriginSegVersion());
            return result;
        }).orElse(null);
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)hbciDialog.getPassport(), originJob);
        hktan.setProcess(KnownTANProcess.PROCESS2_STEP2);
        hktan.setParam("orderref", hbciTanSubmit.getOrderRef());
        hktan.setParam("notlasttan", "N");
        hbciDialog.addTask((AbstractHBCIJob)hktan, false);
        return originJob;
    }

    private SubmitAuthorizationCodeResponse<?> createResponse(PinTanPassport passport, HbciTanSubmit hbciTanSubmit, AbstractHBCIJob hbciJob, HBCIExecStatus status) {
        String transactionId = Optional.ofNullable(hbciJob).map(abstractHBCIJob -> this.orderIdFromJobResult(abstractHBCIJob.getJobResult())).orElse(hbciTanSubmit.getOrderRef());
        SubmitAuthorizationCodeResponse response = new SubmitAuthorizationCodeResponse(((ScaRequiredJob)this.scaJob).createJobResponse(passport, hbciJob));
        response.setTransactionId(transactionId);
        if (!status.getDialogStatus().msgStatusList.isEmpty()) {
            response.setStatus(((HBCIMsgStatus)status.getDialogStatus().msgStatusList.get((int)0)).segStatus.toString());
        }
        return response;
    }

    private HbciTanSubmit evaluateTanSubmit(HBCIConsent hbciConsent) {
        if (hbciConsent.getHbciTanSubmit() instanceof HbciTanSubmit) {
            return (HbciTanSubmit)hbciConsent.getHbciTanSubmit();
        }
        return this.deserializeTanSubmit((byte[])hbciConsent.getHbciTanSubmit());
    }

    private HbciTanSubmit deserializeTanSubmit(byte[] data) {
        try {
            return (HbciTanSubmit)this.objectMapper().readValue(data, HbciTanSubmit.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not deserialize HbciTanSubmit", e);
        }
    }

    private HbciPassport createPassport(final SubmitAuthorisationCode submitAuthorizationCode, HbciTanSubmit hbciTanSubmit) {
        HashMap<String, String> bpd = new HashMap<String, String>();
        bpd.put("Params." + hbciTanSubmit.getOriginLowLevelName() + "Par" + hbciTanSubmit.getOriginSegVersion() + ".Par" + hbciTanSubmit.getOriginLowLevelName() + ".suppformats", hbciTanSubmit.getPainVersion());
        bpd.put("Params." + hbciTanSubmit.getOriginLowLevelName() + "Par" + hbciTanSubmit.getOriginSegVersion() + ".SegHead.code", hbciTanSubmit.getHbciJobName());
        bpd.put("Params.TAN2StepPar" + hbciTanSubmit.getTwoStepMechanism().getSegversion() + ".SegHead.code", "HKTAN");
        bpd.put("BPA.numgva", "100");
        HbciPassport.State state = HbciPassport.State.fromJson(hbciTanSubmit.getPassportState());
        HbciPassport hbciPassport = HbciDialogFactory.createPassport(state, new HbciCallback(){

            @Override
            public String needTAN() {
                return ((HBCIConsent)submitAuthorizationCode.getOriginTransactionRequest().getBankApiConsentData()).getScaAuthenticationData();
            }
        });
        state.apply(hbciPassport);
        HBCIConsent hbciConsent = (HBCIConsent)submitAuthorizationCode.getOriginTransactionRequest().getBankApiConsentData();
        hbciPassport.setPIN(hbciConsent.getCredentials().getPin());
        hbciPassport.setCurrentSecMechInfo(hbciTanSubmit.getTwoStepMechanism());
        hbciPassport.setBPD(bpd);
        return hbciPassport;
    }

    private ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.findAndRegisterModules();
        return objectMapper;
    }

    private String orderIdFromJobResult(HBCIJobResult jobResult) {
        return ((ScaRequiredJob)this.scaJob).orderIdFromJobResult(jobResult);
    }

    public SubmitAuthorisationCodeJob(J scaJob) {
        this.scaJob = scaJob;
    }
}

