/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.ChallengeData;
import de.adorsys.multibanking.domain.Product;
import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.exception.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.hbci.model.HBCIConsent;
import de.adorsys.multibanking.hbci.model.HbciCallback;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciDialogRequest;
import de.adorsys.multibanking.hbci.model.HbciObjectMapper;
import de.adorsys.multibanking.hbci.model.HbciObjectMapperImpl;
import de.adorsys.multibanking.hbci.model.HbciPassport;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.iban4j.Iban;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.manager.ChallengeInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIMessage;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.manager.KnownReturncode;
import org.kapott.hbci.manager.KnownTANProcess;
import org.kapott.hbci.manager.MatrixCode;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScaRequiredJob<T extends AbstractScaTransaction, R extends AbstractResponse> {
    private static final Logger log = LoggerFactory.getLogger(ScaRequiredJob.class);
    static HbciObjectMapper hbciObjectMapper = new HbciObjectMapperImpl();

    public R authorisationAwareExecute(HbciCallback hbciCallback) {
        HbciTanSubmit hbciTanSubmit = new HbciTanSubmit();
        AuthorisationCodeResponse authorisationCodeResponse = AuthorisationCodeResponse.builder().tanSubmit((Object)hbciTanSubmit).build();
        HBCIDialog dialog = this.createAndStartDialog(hbciCallback, authorisationCodeResponse);
        AbstractHBCIJob hbciJob = this.createScaMessage(dialog.getPassport());
        boolean tan2StepRequired = hbciJob == null || dialog.getPassport().tan2StepRequired(hbciJob);
        GVTAN2Step hktan = null;
        if (tan2StepRequired) {
            hktan = this.requestAuthorisationCode(hbciTanSubmit, dialog, hbciJob);
        } else {
            dialog.addTask(hbciJob);
        }
        this.execute(dialog, !tan2StepRequired);
        tan2StepRequired = Optional.ofNullable(hktan).map(gvtan2Step -> KnownReturncode.W3076.searchReturnValue(gvtan2Step.getJobResult().getJobStatus().getRetVals()) == null).orElse(false);
        R jobResponse = this.createJobResponse(dialog.getPassport(), null);
        if (tan2StepRequired) {
            this.updateTanSubmit(hbciTanSubmit, dialog, hbciJob);
            jobResponse.setAuthorisationCodeResponse(authorisationCodeResponse);
            return jobResponse;
        }
        dialog.close();
        return jobResponse;
    }

    private GVTAN2Step requestAuthorisationCode(HbciTanSubmit hbciTanSubmit, HBCIDialog dialog, AbstractHBCIJob hbciJob) {
        HBCITwoStepMechanism hbciTwoStepMechanism = this.getUserTanTransportType(dialog);
        dialog.getPassport().setCurrentSecMechInfo(hbciTwoStepMechanism);
        if (hbciTwoStepMechanism.getProcess() == 1 && hbciJob == null) {
            throw new MultibankingException(MultibankingError.INTERNAL_ERROR, "Tan requests without corresponding transaction not supported with HKTAN process variant 1");
        }
        if (hbciJob == null || hbciTwoStepMechanism.getProcess() == 2) {
            return this.hktanProcess2(dialog, hbciTwoStepMechanism, hbciJob);
        }
        return this.hktanProcess1(dialog, hbciTwoStepMechanism, hbciTanSubmit, hbciJob);
    }

    private void updateTanSubmit(HbciTanSubmit hbciTanSubmit, HBCIDialog dialog, AbstractHBCIJob scaJob) {
        hbciTanSubmit.setOriginJobName(Optional.ofNullable(this.getTransactionRequest().getTransaction()).map(transaction -> this.getHbciJobName(transaction.getTransactionType())).orElseGet(() -> this.getHbciJobName(null)));
        hbciTanSubmit.setPassportState(new HbciPassport.State(dialog.getPassport()).toJson());
        hbciTanSubmit.setDialogId(dialog.getDialogID());
        hbciTanSubmit.setMsgNum(dialog.getMsgnum());
        hbciTanSubmit.setTwoStepMechanism(this.getUserTanTransportType(dialog));
        try {
            hbciTanSubmit.setLowLevelParams(new ObjectMapper().writeValueAsString((Object)scaJob.getLowlevelParams()));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new MultibankingException(MultibankingError.INTERNAL_ERROR, 500, e.getMessage());
        }
        Optional.ofNullable(scaJob).ifPresent(hbciJob -> {
            Optional.ofNullable(hbciJob.getPainVersion()).ifPresent(painVersion -> hbciTanSubmit.setPainVersion(painVersion.getURN()));
            hbciTanSubmit.setOriginLowLevelName(hbciJob.getJobName());
            hbciTanSubmit.setOriginSegVersion(hbciJob.getSegVersion());
            hbciTanSubmit.setHbciJobName(hbciJob.getHBCICode(false));
        });
    }

    private HBCIDialog createAndStartDialog(HbciCallback hbciCallback, AuthorisationCodeResponse authorisationCodeResponse) {
        HbciCallback callback = this.createCallback(hbciCallback, authorisationCodeResponse);
        HbciDialogRequest dialogRequest = this.createDialogRequest(callback);
        return HbciDialogFactory.startHbciDialog(null, dialogRequest);
    }

    void execute(HBCIDialog dialog, boolean closeDialog) {
        HBCIExecStatus status = dialog.execute(closeDialog);
        if (!status.isOK()) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, status.getDialogStatus().getErrorMessages().stream().map(messageString -> Message.builder().renderedMessage(messageString).build()).collect(Collectors.toList()));
        }
    }

    private GVTAN2Step hktanProcess1(HBCIDialog dialog, HBCITwoStepMechanism hbciTwoStepMechanism, HbciTanSubmit hbciTanSubmit, AbstractHBCIJob hbciJob) {
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)dialog.getPassport(), hbciJob);
        hktan.setProcess(KnownTANProcess.PROCESS1);
        hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
        if (dialog.getPassport().tanMediaNeeded()) {
            hktan.setParam("tanmedia", this.getConsent().getSelectedMethod().getMedium());
        }
        hktan.setParam("notlasttan", "N");
        hktan.setParam("orderhash", hbciJob.createOrderHash(hbciTwoStepMechanism.getSegversion()));
        if (StringUtils.equals((CharSequence)hbciTwoStepMechanism.getNeedchallengeklass(), (CharSequence)"J")) {
            ChallengeInfo cinfo = ChallengeInfo.getInstance();
            cinfo.applyParams(hbciJob, (AbstractHBCIJob)hktan, hbciTwoStepMechanism);
        }
        hbciTanSubmit.setSepaPain(hbciJob.getRawData());
        dialog.addTask((AbstractHBCIJob)hktan, false);
        return hktan;
    }

    private GVTAN2Step hktanProcess2(HBCIDialog dialog, HBCITwoStepMechanism hbciTwoStepMechanism, AbstractHBCIJob hbciJob) {
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)dialog.getPassport(), hbciJob);
        hktan.setProcess(KnownTANProcess.PROCESS2_STEP1);
        hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
        if (dialog.getPassport().tanMediaNeeded()) {
            hktan.setParam("tanmedia", this.getConsent().getSelectedMethod().getMedium());
        }
        hktan.setParam("orderaccount", this.getPsuKonto(dialog.getPassport()));
        hktan.setParam("ordersegcode", Optional.ofNullable(hbciJob).map(AbstractHBCIJob::getHBCICode).orElse("HKIDN"));
        Optional<HBCIMessage> messages = Optional.ofNullable(hbciJob).map(arg_0 -> ((HBCIDialog)dialog).addTask(arg_0));
        if (messages.isPresent()) {
            messages.get().append((AbstractHBCIJob)hktan);
        } else {
            dialog.addTask((AbstractHBCIJob)hktan);
        }
        return hktan;
    }

    Konto getPsuKonto(PinTanPassport passport) {
        return this.getPsuAccount().map(account -> {
            Konto konto = passport.findAccountByAccountNumber(Iban.valueOf((String)account.getIban()).getAccountNumber());
            konto.iban = account.getIban();
            konto.bic = Optional.ofNullable(account.getBic()).orElse(HBCIUtils.getBankInfo((String)konto.blz).getBic());
            return konto;
        }).orElseGet(() -> (Konto)passport.getAccounts().get(0));
    }

    private Optional<BankAccount> getPsuAccount() {
        return Optional.ofNullable(this.getTransactionRequest().getTransaction().getPsuAccount());
    }

    private HBCITwoStepMechanism getUserTanTransportType(HBCIDialog dialog) {
        return Optional.ofNullable(this.getConsent().getSelectedMethod()).map(tanTransportType -> (HBCITwoStepMechanism)dialog.getPassport().getBankTwostepMechanisms().get(tanTransportType.getId())).map(hbciTwoStepMechanism -> {
            hbciTwoStepMechanism.setMedium(this.getConsent().getSelectedMethod().getMedium());
            return hbciTwoStepMechanism;
        }).orElseGet(() -> (HBCITwoStepMechanism)dialog.getPassport().getBankTwostepMechanisms().get(dialog.getPassport().getUserTwostepMechanisms().get(0)));
    }

    private HbciCallback createCallback(final HbciCallback hbciCallback, final AuthorisationCodeResponse response) {
        return new HbciCallback(){

            @Override
            public void tanChallengeCallback(String orderRef, String challenge, String challengeHhdUc, HHDVersion.Type type) {
                ((HbciTanSubmit)response.getTanSubmit()).setOrderRef(orderRef);
                if (challenge != null) {
                    ChallengeData challengeData = new ChallengeData();
                    challengeData.setAdditionalInformation(challenge);
                    if (challengeHhdUc != null) {
                        try {
                            byte[] image = new MatrixCode(challengeHhdUc).getImage();
                            challengeData.setImage(new String(image, StandardCharsets.UTF_8));
                        }
                        catch (Exception e) {
                            challengeData.setData(Collections.singletonList(challengeHhdUc));
                        }
                    }
                    UpdateAuthResponse updateAuthResponse = new UpdateAuthResponse();
                    updateAuthResponse.setBankApi(BankApi.HBCI);
                    updateAuthResponse.setScaStatus(ScaStatus.SCAMETHODSELECTED);
                    updateAuthResponse.setScaApproach(ScaApproach.EMBEDDED);
                    updateAuthResponse.setChallenge(challengeData);
                    response.setUpdateAuthResponse(updateAuthResponse);
                }
            }

            @Override
            public void status(int statusTag, Object o) {
                Optional.ofNullable(hbciCallback).ifPresent(callback -> callback.status(statusTag, o));
            }

            @Override
            public void status(int statusTag, Object[] o) {
                Optional.ofNullable(hbciCallback).ifPresent(callback -> callback.status(statusTag, o));
            }
        };
    }

    private HbciDialogRequest createDialogRequest(HbciCallback hbciCallback) {
        TransactionRequest<T> transactionRequest = this.getTransactionRequest();
        HbciDialogRequest hbciDialogRequest = HbciDialogRequest.builder().credentials(this.getConsent().getCredentials()).hbciPassportState(transactionRequest.getBankAccess().getHbciPassportState()).callback(hbciCallback).build();
        hbciDialogRequest.setBank(transactionRequest.getBank());
        hbciDialogRequest.setHbciProduct(Optional.ofNullable(transactionRequest.getHbciProduct()).map(product -> new Product(product.getName(), product.getVersion())).orElse(null));
        hbciDialogRequest.setHbciBPD(transactionRequest.getHbciBPD());
        hbciDialogRequest.setHbciUPD(transactionRequest.getHbciUPD());
        hbciDialogRequest.setHbciSysId(transactionRequest.getHbciSysId());
        return hbciDialogRequest;
    }

    private HBCIConsent getConsent() {
        return (HBCIConsent)this.getTransactionRequest().getBankApiConsentData();
    }

    public abstract AbstractHBCIJob createScaMessage(PinTanPassport var1);

    public abstract List<AbstractHBCIJob> createAdditionalMessages(PinTanPassport var1);

    abstract TransactionRequest<T> getTransactionRequest();

    abstract String getHbciJobName(AbstractScaTransaction.TransactionType var1);

    abstract R createJobResponse(PinTanPassport var1, AbstractHBCIJob var2);

    public abstract String orderIdFromJobResult(HBCIJobResult var1);
}

