/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.exception.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.LoadBalancesResponse;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.LoadBalances;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVSaldoReq;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancesJob
extends ScaRequiredJob<LoadBalances, LoadBalancesResponse> {
    private static final Logger log = LoggerFactory.getLogger(LoadBalancesJob.class);
    private final TransactionRequest<LoadBalances> loadBalanceRequest;
    private AbstractHBCIJob balanceJob;

    private static boolean initFailed(HBCIExecStatus status) {
        return status.getErrorMessages().stream().anyMatch(line -> line.charAt(0) == '9');
    }

    private Konto createAccount(BankAccount bankAccount) {
        Konto account = new Konto();
        account.bic = bankAccount.getBic();
        account.number = bankAccount.getAccountNumber();
        account.iban = bankAccount.getIban();
        account.blz = bankAccount.getBlz();
        account.curr = bankAccount.getCurrency();
        account.country = bankAccount.getCountry();
        return account;
    }

    @Override
    public AbstractHBCIJob createScaMessage(PinTanPassport passport) {
        this.balanceJob = new GVSaldoReq((HBCIPassportInternal)passport);
        this.balanceJob.setParam("my", this.createAccount(((LoadBalances)this.loadBalanceRequest.getTransaction()).getPsuAccount()));
        return this.balanceJob;
    }

    @Override
    public List<AbstractHBCIJob> createAdditionalMessages(PinTanPassport passport) {
        return Collections.emptyList();
    }

    @Override
    protected void execute(HBCIDialog dialog, boolean closeDialog) {
        HBCIExecStatus status = dialog.execute(closeDialog);
        if (!status.isOK()) {
            log.error("Status of balance job not OK " + status);
            if (LoadBalancesJob.initFailed(status)) {
                throw new MultibankingException(MultibankingError.HBCI_ERROR, status.getDialogStatus().getErrorMessages().stream().map(messageString -> Message.builder().renderedMessage(messageString).build()).collect(Collectors.toList()));
            }
        }
    }

    @Override
    TransactionRequest<LoadBalances> getTransactionRequest() {
        return this.loadBalanceRequest;
    }

    @Override
    String getHbciJobName(AbstractScaTransaction.TransactionType transactionType) {
        return GVSaldoReq.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult jobResult) {
        return null;
    }

    @Override
    public LoadBalancesResponse createJobResponse(PinTanPassport passport, AbstractHBCIJob hbciJob) {
        AbstractHBCIJob resultJob = Optional.ofNullable(hbciJob).orElse(this.balanceJob);
        if (resultJob.getJobResult().getJobStatus().hasErrors()) {
            log.error("Balance job not OK");
            throw new MultibankingException(MultibankingError.HBCI_ERROR, resultJob.getJobResult().getJobStatus().getErrorList().stream().map(messageString -> Message.builder().renderedMessage(messageString).build()).collect(Collectors.toList()));
        }
        BankAccount bankAccount = ((LoadBalances)this.loadBalanceRequest.getTransaction()).getPsuAccount();
        if (resultJob.getJobResult().isOK()) {
            bankAccount.setBalances(hbciObjectMapper.createBalancesReport((GVRSaldoReq)resultJob.getJobResult(), bankAccount.getAccountNumber()));
        }
        return new LoadBalancesResponse(bankAccount);
    }

    public TransactionRequest<LoadBalances> getLoadBalanceRequest() {
        return this.loadBalanceRequest;
    }

    public AbstractHBCIJob getBalanceJob() {
        return this.balanceJob;
    }

    public void setBalanceJob(AbstractHBCIJob balanceJob) {
        this.balanceJob = balanceJob;
    }

    public String toString() {
        return "LoadBalancesJob(loadBalanceRequest=" + this.getLoadBalanceRequest() + ", balanceJob=" + this.getBalanceJob() + ")";
    }

    public LoadBalancesJob(TransactionRequest<LoadBalances> loadBalanceRequest) {
        this.loadBalanceRequest = loadBalanceRequest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadBalancesJob)) {
            return false;
        }
        LoadBalancesJob other = (LoadBalancesJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransactionRequest<LoadBalances> this$loadBalanceRequest = this.getLoadBalanceRequest();
        TransactionRequest<LoadBalances> other$loadBalanceRequest = other.getLoadBalanceRequest();
        if (this$loadBalanceRequest == null ? other$loadBalanceRequest != null : !this$loadBalanceRequest.equals(other$loadBalanceRequest)) {
            return false;
        }
        AbstractHBCIJob this$balanceJob = this.getBalanceJob();
        AbstractHBCIJob other$balanceJob = other.getBalanceJob();
        return !(this$balanceJob == null ? other$balanceJob != null : !this$balanceJob.equals(other$balanceJob));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoadBalancesJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionRequest<LoadBalances> $loadBalanceRequest = this.getLoadBalanceRequest();
        result = result * 59 + ($loadBalanceRequest == null ? 43 : $loadBalanceRequest.hashCode());
        AbstractHBCIJob $balanceJob = this.getBalanceJob();
        result = result * 59 + ($balanceJob == null ? 43 : $balanceJob.hashCode());
        return result;
    }
}

