/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.EmptyResponse;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.ForeignPayment;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import java.util.Collections;
import java.util.List;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVDTAZV;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;

public class ForeignPaymentJob
extends ScaRequiredJob<ForeignPayment, EmptyResponse> {
    private final TransactionRequest<ForeignPayment> transactionRequest;

    @Override
    public AbstractHBCIJob createScaMessage(PinTanPassport passport) {
        Konto src = this.getPsuKonto(passport);
        GVDTAZV gv = new GVDTAZV((HBCIPassportInternal)passport, GVDTAZV.getLowlevelName());
        gv.setParam("src", src);
        gv.setParam("dtazv", "B" + ((ForeignPayment)this.transactionRequest.getTransaction()).getRawData());
        gv.verifyConstraints();
        return gv;
    }

    @Override
    public List<AbstractHBCIJob> createAdditionalMessages(PinTanPassport passport) {
        return Collections.emptyList();
    }

    @Override
    EmptyResponse createJobResponse(PinTanPassport passport, AbstractHBCIJob hbciJob) {
        return new EmptyResponse();
    }

    @Override
    TransactionRequest<ForeignPayment> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    protected String getHbciJobName(AbstractScaTransaction.TransactionType transactionType) {
        return GVDTAZV.getLowlevelName();
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return null;
    }

    public ForeignPaymentJob(TransactionRequest<ForeignPayment> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

