/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.EmptyResponse;
import de.adorsys.multibanking.domain.transaction.AbstractScaTransaction;
import de.adorsys.multibanking.domain.transaction.FutureSinglePayment;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import java.util.Collections;
import java.util.List;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTermUebSEPADel;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class DeleteFutureSinglePaymentJob
extends ScaRequiredJob<FutureSinglePayment, EmptyResponse> {
    private final TransactionRequest<FutureSinglePayment> transactionRequest;
    private String jobName;

    @Override
    public AbstractHBCIJob createScaMessage(PinTanPassport passport) {
        FutureSinglePayment singlePayment = (FutureSinglePayment)this.transactionRequest.getTransaction();
        Konto src = this.getPsuKonto(passport);
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic();
        this.jobName = GVTermUebSEPADel.getLowlevelName();
        GVTermUebSEPADel sepadelgv = new GVTermUebSEPADel((HBCIPassportInternal)passport, this.jobName, null);
        sepadelgv.setParam("orderid", singlePayment.getOrderId());
        sepadelgv.setParam("date", singlePayment.getExecutionDate().toString());
        sepadelgv.setParam("src", src);
        sepadelgv.setParam("dst", dst);
        sepadelgv.setParam("btg", new Value(singlePayment.getAmount(), singlePayment.getCurrency()));
        if (singlePayment.getPurpose() != null) {
            sepadelgv.setParam("usage", singlePayment.getPurpose());
        }
        sepadelgv.verifyConstraints();
        return sepadelgv;
    }

    @Override
    public List<AbstractHBCIJob> createAdditionalMessages(PinTanPassport passport) {
        return Collections.emptyList();
    }

    @Override
    EmptyResponse createJobResponse(PinTanPassport passport, AbstractHBCIJob hbciJob) {
        return new EmptyResponse();
    }

    @Override
    TransactionRequest<FutureSinglePayment> getTransactionRequest() {
        return this.transactionRequest;
    }

    @Override
    protected String getHbciJobName(AbstractScaTransaction.TransactionType transactionType) {
        return this.jobName;
    }

    @Override
    public String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return null;
    }

    public DeleteFutureSinglePaymentJob(TransactionRequest<FutureSinglePayment> transactionRequest) {
        this.transactionRequest = transactionRequest;
    }
}

