/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.Product;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.LoadBalanceRequest;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciDialogRequest;
import de.adorsys.multibanking.hbci.model.HbciMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVSaldoReq;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalanceJob {
    private static final Logger log = LoggerFactory.getLogger(LoadBalanceJob.class);

    public static List<BankAccount> loadBalances(LoadBalanceRequest loadBalanceRequest) {
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(loadBalanceRequest.getBankCode() != null ? loadBalanceRequest.getBankCode() : loadBalanceRequest.getBankAccess().getBankCode()).customerId(loadBalanceRequest.getBankAccess().getBankLogin()).login(loadBalanceRequest.getBankAccess().getBankLogin2()).hbciPassportState(loadBalanceRequest.getBankAccess().getHbciPassportState()).pin(loadBalanceRequest.getPin()).build();
        dialogRequest.setProduct(Optional.ofNullable(loadBalanceRequest.getProduct()).map(product -> new Product(product.getName(), product.getVersion())).orElse(null));
        dialogRequest.setBpd(loadBalanceRequest.getBpd());
        HBCIDialog dialog = HbciDialogFactory.createDialog(null, dialogRequest);
        HashMap jobs = new HashMap();
        loadBalanceRequest.getBankAccounts().forEach(bankAccount -> {
            Konto account = LoadBalanceJob.createAccount(dialog, bankAccount);
            jobs.put(LoadBalanceJob.createBalanceJob(dialog, account), bankAccount);
        });
        HBCIExecStatus status = dialog.execute(true);
        if (!status.isOK()) {
            log.error("Status of balance job not OK " + status);
            if (LoadBalanceJob.initFailed(status)) {
                throw new MultibankingException(MultibankingError.HBCI_ERROR, status.getDialogStatus().getErrorMessages());
            }
        }
        ArrayList<BankAccount> bankAccounts = new ArrayList<BankAccount>();
        jobs.keySet().forEach(job -> {
            if (job.getJobResult().getJobStatus().hasErrors()) {
                log.error("Balance job not OK");
                throw new MultibankingException(MultibankingError.HBCI_ERROR, job.getJobResult().getJobStatus().getErrorList());
            }
            BankAccount bankAccount = (BankAccount)jobs.get(job);
            bankAccount.setBalances(HbciMapping.createBalance((GVRSaldoReq)job.getJobResult(), bankAccount.getAccountNumber()));
            bankAccounts.add(bankAccount);
        });
        return bankAccounts;
    }

    private static AbstractHBCIJob createBalanceJob(HBCIDialog dialog, Konto konto) {
        GVSaldoReq balanceJob = new GVSaldoReq((HBCIPassportInternal)dialog.getPassport());
        balanceJob.setParam("my", konto);
        dialog.addTask((AbstractHBCIJob)balanceJob);
        return balanceJob;
    }

    private static Konto createAccount(HBCIDialog dialog, BankAccount bankAccount) {
        Konto account = dialog.getPassport().findAccountByAccountNumber(bankAccount.getAccountNumber());
        account.iban = bankAccount.getIban();
        account.bic = bankAccount.getBic();
        account.curr = bankAccount.getCurrency();
        account.country = bankAccount.getCountry();
        return account;
    }

    private static boolean initFailed(HBCIExecStatus status) {
        return status.getErrorMessages().stream().anyMatch(line -> line.charAt(0) == '9');
    }

    private LoadBalanceJob() {
    }
}

