/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.Product;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.LoadAccountInformationRequest;
import de.adorsys.multibanking.domain.response.LoadAccountInformationResponse;
import de.adorsys.multibanking.hbci.model.HbciCallback;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciDialogRequest;
import de.adorsys.multibanking.hbci.model.HbciMapping;
import de.adorsys.multibanking.hbci.model.HbciPassport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVSEPAInfo;
import org.kapott.hbci.GV.GVTANMediaList;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountInformationJob {
    private static final Logger log = LoggerFactory.getLogger(AccountInformationJob.class);

    public static List<TanTransportType> extractTanTransportTypes(PinTanPassport hbciPassport) {
        return hbciPassport.getUserTwostepMechanisms().stream().map(id -> (HBCITwoStepMechanism)hbciPassport.getBankTwostepMechanisms().get(id)).filter(Objects::nonNull).map(hbciTwoStepMechanism -> TanTransportType.builder().id(hbciTwoStepMechanism.getSecfunc()).name(hbciTwoStepMechanism.getName()).inputInfo(hbciTwoStepMechanism.getInputinfo()).medium(hbciPassport.getTanMedia(hbciTwoStepMechanism.getId()) != null ? hbciPassport.getTanMedia((String)hbciTwoStepMechanism.getId()).mediaName : null).build()).collect(Collectors.toList());
    }

    public LoadAccountInformationResponse loadBankAccounts(LoadAccountInformationRequest request, HbciCallback callback) {
        log.info("Loading account list for bank [{}]", (Object)request.getBankCode());
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(request.getBankCode() != null ? request.getBankCode() : request.getBankAccess().getBankCode()).customerId(request.getBankAccess().getBankLogin()).login(request.getBankAccess().getBankLogin2()).hbciPassportState(request.getBankAccess().getHbciPassportState()).pin(request.getPin()).callback(callback).build();
        dialogRequest.setProduct(Optional.ofNullable(request.getProduct()).map(product -> new Product(product.getName(), product.getVersion())).orElse(null));
        dialogRequest.setBpd(request.getBpd());
        HBCIDialog dialog = HbciDialogFactory.createDialog(null, dialogRequest);
        if (!dialog.getPassport().jobSupported("SEPAInfo")) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, "SEPAInfo job not supported");
        }
        log.info("fetching SEPA informations");
        GVSEPAInfo gvsepaInfo = new GVSEPAInfo((HBCIPassportInternal)dialog.getPassport());
        dialog.addTask((AbstractHBCIJob)gvsepaInfo);
        if (request.isUpdateTanTransportTypes() && dialog.getPassport().jobSupported("TANMediaList")) {
            log.info("fetching TAN media list");
            dialog.addTask((AbstractHBCIJob)new GVTANMediaList((HBCIPassportInternal)dialog.getPassport()));
        }
        dialog.execute(true);
        if (gvsepaInfo.getJobResult().getJobStatus().hasErrors()) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, gvsepaInfo.getJobResult().getJobStatus().getErrorList());
        }
        request.getBankAccess().setBankName(dialog.getPassport().getInstName());
        ArrayList<BankAccount> hbciAccounts = new ArrayList<BankAccount>();
        for (Konto konto : dialog.getPassport().getAccounts()) {
            BankAccount bankAccount = HbciMapping.toBankAccount(konto);
            bankAccount.externalId(BankApi.HBCI, UUID.randomUUID().toString());
            bankAccount.bankName(request.getBankAccess().getBankName());
            hbciAccounts.add(bankAccount);
        }
        if (request.isUpdateTanTransportTypes()) {
            request.getBankAccess().setTanTransportTypes(new HashMap());
            request.getBankAccess().getTanTransportTypes().put(BankApi.HBCI, AccountInformationJob.extractTanTransportTypes(dialog.getPassport()));
        }
        request.getBankAccess().setHbciPassportState(new HbciPassport.State(dialog.getPassport()).toJson());
        return LoadAccountInformationResponse.builder().bankAccess(request.getBankAccess()).bankAccounts(hbciAccounts).build();
    }
}

