/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.model;

import de.adorsys.multibanking.domain.Balance;
import de.adorsys.multibanking.domain.BalancesReport;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankAccountType;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.Booking;
import de.adorsys.multibanking.domain.Cycle;
import de.adorsys.multibanking.domain.StandingOrder;
import de.adorsys.multibanking.domain.utils.Utils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.WordUtils;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Saldo;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HbciMapping {
    private static final Logger log = LoggerFactory.getLogger(HbciMapping.class);

    public static BalancesReport createBalance(GVRSaldoReq gvSaldoReq) {
        GVRSaldoReq.Info[] infos;
        BalancesReport result = new BalancesReport();
        if (gvSaldoReq.isOK() && (infos = gvSaldoReq.getEntries()).length > 0) {
            if (infos[0] != null && infos[0].ready != null && infos[0].ready.value != null) {
                result.setReadyBalance(HbciMapping.createBalance(infos[0].ready));
            }
            if (infos[0] != null && infos[0].available != null) {
                result.setAvailableBalance(HbciMapping.createBalance(infos[0].available));
            }
            if (infos[0] != null && infos[0].kredit != null) {
                result.setCreditBalance(HbciMapping.createBalance(infos[0].kredit));
            }
            if (infos[0] != null && infos[0].unready != null && infos[0].unready.value != null) {
                result.setUnreadyBalance(HbciMapping.createBalance(infos[0].unready));
            }
            if (infos[0] != null && infos[0].used != null) {
                result.setUsedBalance(HbciMapping.createBalance(infos[0].used));
            }
        }
        return result;
    }

    private static Balance createBalance(Value value) {
        return Balance.builder().currency(value.getCurr()).amount(value.getBigDecimalValue().setScale(2)).build();
    }

    private static Balance createBalance(Saldo saldo) {
        return Balance.builder().date(saldo.timestamp.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).currency(saldo.value.getCurr()).amount(saldo.value.getBigDecimalValue().setScale(2)).build();
    }

    public static List<StandingOrder> createStandingOrders(GVRDauerList gvrDauerList) {
        GVRDauerList.Dauer[] lines = gvrDauerList.getEntries();
        ArrayList<StandingOrder> standingOrders = new ArrayList<StandingOrder>();
        for (int i = 0; i < lines.length; ++i) {
            GVRDauerList.Dauer line = lines[i];
            StandingOrder auftrag = new StandingOrder();
            if (line.firstdate != null) {
                auftrag.setFirstExecutionDate(line.firstdate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            if (line.lastdate != null) {
                auftrag.setLastExecutionDate(line.lastdate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            auftrag.setAmount(line.value.getBigDecimalValue());
            auftrag.setOrderId(line.orderid);
            auftrag.setOtherAccount(HbciMapping.toBankAccount(line.other));
            auftrag.setUsage(HbciMapping.getUsage(Arrays.asList(line.usage)));
            auftrag.setExecutionDay(line.execday);
            Cycle cycle = null;
            if (!StringUtils.endsWithIgnoreCase((CharSequence)"M", (CharSequence)line.timeunit)) {
                cycle = Cycle.WEEKLY;
            } else {
                switch (line.turnus) {
                    case 1: {
                        cycle = Cycle.MONTHLY;
                        break;
                    }
                    case 2: {
                        cycle = Cycle.TWO_MONTHLY;
                        break;
                    }
                    case 3: {
                        cycle = Cycle.QUARTERLY;
                        break;
                    }
                    case 6: {
                        cycle = Cycle.HALF_YEARLY;
                        break;
                    }
                    case 12: {
                        cycle = Cycle.YEARLY;
                    }
                }
            }
            auftrag.setCycle(cycle);
            standingOrders.add(auftrag);
        }
        return standingOrders;
    }

    public static List<Booking> createBookings(GVRKUms gvrkUms) {
        ArrayList<Booking> bookings = new ArrayList<Booking>();
        if (gvrkUms.isOK()) {
            List lines = gvrkUms.getFlatData();
            for (GVRKUms.UmsLine line : lines) {
                if (line == null) continue;
                if (line.value == null) {
                    log.warn("Booking has no amount, skipping: %s", (Object)line);
                    continue;
                }
                if (line.bdate == null) {
                    log.warn("Booking has no booking date, skipping: %s", (Object)line);
                    continue;
                }
                Booking booking = new Booking();
                booking.setBankApi(BankApi.HBCI);
                booking.setBookingDate(line.bdate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                booking.setAmount(line.value.getBigDecimalValue().setScale(2));
                booking.setCurrency(line.value.getCurr());
                booking.setAdditional(line.additional);
                booking.setAddkey(line.addkey);
                booking.setCustomerRef(line.customerref);
                booking.setInstRef(line.instref);
                booking.setReversal(line.isStorno);
                booking.setSepa(line.isSepa);
                booking.setPrimanota(line.primanota);
                booking.setText(line.text);
                booking.setValutaDate(line.valuta.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                if (line.saldo != null && line.saldo.value != null) {
                    booking.setBalance(line.saldo.value.getBigDecimalValue().setScale(2));
                }
                if (line.charge_value != null) {
                    booking.setChargeValue(line.charge_value.getBigDecimalValue().setScale(2));
                }
                if (line.orig_value != null) {
                    booking.setOrigValue(line.orig_value.getBigDecimalValue().setScale(2));
                }
                if (line.other != null) {
                    booking.setOtherAccount(HbciMapping.toBankAccount(line.other));
                    String differentInitiator = Utils.extractDifferentInitiator((String)booking.getUsage());
                    if (differentInitiator != null) {
                        booking.getOtherAccount().setOwner(booking.getOtherAccount().getOwner() + " " + differentInitiator);
                    }
                    if (StringUtils.isBlank((CharSequence)booking.getOtherAccount().getIban())) {
                        booking.getOtherAccount().setIban(Utils.extractIban((String)booking.getUsage()));
                    }
                }
                booking.setExternalId("B-" + line.valuta.getTime() + "_" + line.value.getLongValue() + "_" + line.saldo.value.getLongValue());
                booking.setUsage(HbciMapping.getUsage(line.usage.size() > 0 ? line.usage : HbciMapping.splitEqually(line.additional, 27)));
                booking.setCreditorId(Utils.extractCreditorId((String)booking.getUsage()));
                booking.setMandateReference(Utils.extractMandateReference((String)booking.getUsage()));
                bookings.add(0, booking);
            }
        }
        log.debug("Received {} bookings: {}", (Object)bookings.size(), bookings);
        return bookings;
    }

    public static BankAccount toBankAccount(Konto konto) {
        BankAccount bankAccount = new BankAccount();
        bankAccount.accountNumber(konto.number);
        bankAccount.bic(konto.bic);
        bankAccount.blz(konto.blz);
        bankAccount.country(konto.country);
        bankAccount.currency(konto.curr);
        bankAccount.iban(konto.iban);
        bankAccount.owner((konto.name + (konto.name2 != null ? konto.name2 : "")).trim());
        bankAccount.name(konto.type);
        bankAccount.type(BankAccountType.fromHbciType((Integer)NumberUtils.toInt((String)konto.acctype)));
        return bankAccount;
    }

    public static String cycleToTurnus(Cycle cycle) {
        switch (cycle) {
            case WEEKLY: {
                return "1";
            }
            case TWO_WEEKLY: {
                return "2";
            }
            case MONTHLY: {
                return "1";
            }
            case TWO_MONTHLY: {
                return "2";
            }
            case QUARTERLY: {
                return "3";
            }
            case HALF_YEARLY: {
                return "6";
            }
            case YEARLY: {
                return "12";
            }
        }
        return null;
    }

    public static String cycleToTimeunit(Cycle cycle) {
        switch (cycle) {
            case WEEKLY: 
            case TWO_WEEKLY: {
                return "W";
            }
        }
        return "M";
    }

    private static String getUsage(List<String> lines) {
        StringBuilder sb = new StringBuilder();
        if (lines != null) {
            for (String line : lines) {
                if (line == null) continue;
                sb.append(StringUtils.chomp((String)line));
                sb.append(line.length() < 27 ? " " : "");
            }
        }
        return WordUtils.capitalizeFully((String)sb.toString().trim(), (char[])new char[]{' ', '/'});
    }

    public static List<String> splitEqually(String text, int size) {
        if (text == null || text.length() == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        for (int start = 0; start < text.length(); start += size) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
        }
        return ret;
    }
}

