/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.multibanking.domain.AbstractScaTransaction;
import de.adorsys.multibanking.domain.Product;
import de.adorsys.multibanking.domain.TanChallenge;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.SubmitAuthorizationCodeRequest;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.response.SubmitAuthorizationCodeResponse;
import de.adorsys.multibanking.hbci.model.HbciCallback;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciDialogRequest;
import de.adorsys.multibanking.hbci.model.HbciPassport;
import de.adorsys.multibanking.hbci.model.HbciTanSubmit;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.manager.ChallengeInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIJobFactory;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIMsgStatus;
import org.kapott.hbci.structures.Konto;

public abstract class ScaRequiredJob {
    private static ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.findAndRegisterModules();
        return objectMapper;
    }

    public AuthorisationCodeResponse requestAuthorizationCode(TransactionRequest sepaTransactionRequest) {
        HBCIExecStatus status;
        final HbciTanSubmit hbciTanSubmit = new HbciTanSubmit();
        final AuthorisationCodeResponse response = new AuthorisationCodeResponse();
        response.setTanSubmit((Object)hbciTanSubmit);
        Optional.ofNullable(sepaTransactionRequest.getTransaction()).ifPresent(sepaTransaction -> hbciTanSubmit.setOriginJobName(this.getHbciJobName(sepaTransaction.getTransactionType())));
        HbciCallback hbciCallback = new HbciCallback(){

            @Override
            public void tanChallengeCallback(String orderRef, String challenge, String challengeHhdUc, HHDVersion.Type type) {
                hbciTanSubmit.setOrderRef(orderRef);
                if (challenge != null) {
                    response.setChallenge(TanChallenge.builder().title(challenge).data(challengeHhdUc).build());
                }
            }
        };
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(sepaTransactionRequest.getBankCode() != null ? sepaTransactionRequest.getBankCode() : sepaTransactionRequest.getBankAccess().getBankCode()).customerId(sepaTransactionRequest.getBankAccess().getBankLogin()).login(sepaTransactionRequest.getBankAccess().getBankLogin2()).hbciPassportState(sepaTransactionRequest.getBankAccess().getHbciPassportState()).pin(sepaTransactionRequest.getPin()).callback(hbciCallback).build();
        dialogRequest.setProduct(Optional.ofNullable(sepaTransactionRequest.getProduct()).map(product -> new Product(product.getName(), product.getVersion())).orElse(null));
        dialogRequest.setBpd(sepaTransactionRequest.getBpd());
        HBCIDialog dialog = HbciDialogFactory.createDialog(null, dialogRequest);
        HBCITwoStepMechanism hbciTwoStepMechanism = (HBCITwoStepMechanism)dialog.getPassport().getBankTwostepMechanisms().get(sepaTransactionRequest.getTanTransportType().getId());
        if (hbciTwoStepMechanism == null) {
            throw new MultibankingException(MultibankingError.INVALID_SCA_METHOD, "inavalid two stem mechanism: " + sepaTransactionRequest.getTanTransportType().getId());
        }
        dialog.getPassport().setCurrentSecMechInfo(hbciTwoStepMechanism);
        AbstractHBCIJob hbciJob = this.createHbciJob(sepaTransactionRequest.getTransaction(), dialog.getPassport());
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)dialog.getPassport());
        hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
        if (hbciTwoStepMechanism.getProcess() == 1) {
            hbciTanSubmit.setSepaPain(this.hktanProcess1(hbciTwoStepMechanism, hbciJob, hktan));
            dialog.addTask((AbstractHBCIJob)hktan, false);
        } else {
            this.hktanProcess2(dialog, hbciJob, this.getDebtorAccount(sepaTransactionRequest.getTransaction(), dialog.getPassport()), hktan);
        }
        if (dialog.getPassport().tanMediaNeeded()) {
            hktan.setParam("tanmedia", sepaTransactionRequest.getTanTransportType().getMedium());
        }
        if (!(status = dialog.execute(false)).isOK()) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, status.getDialogStatus().getErrorMessages());
        }
        hbciTanSubmit.setPassportState(new HbciPassport.State(dialog.getPassport()).toJson());
        hbciTanSubmit.setDialogId(dialog.getDialogID());
        hbciTanSubmit.setMsgNum(dialog.getMsgnum());
        hbciTanSubmit.setTwoStepMechanism(hbciTwoStepMechanism);
        Optional.ofNullable(hbciJob).ifPresent(abstractSEPAGV -> {
            Optional.ofNullable(abstractSEPAGV.getPainVersion()).ifPresent(painVersion -> hbciTanSubmit.setPainVersion(painVersion.getURN()));
            hbciTanSubmit.setOriginLowLevelName(abstractSEPAGV.getJobName());
            hbciTanSubmit.setOriginSegVersion(abstractSEPAGV.getSegVersion());
            hbciTanSubmit.setHbciJobName(abstractSEPAGV.getHBCICode());
        });
        return response;
    }

    private String hktanProcess1(HBCITwoStepMechanism hbciTwoStepMechanism, AbstractHBCIJob hbciJob, GVTAN2Step hktan) {
        hktan.setParam("process", hbciTwoStepMechanism.getProcess());
        hktan.setParam("notlasttan", "N");
        hktan.setParam("orderhash", hbciJob.createOrderHash(hbciTwoStepMechanism.getSegversion()));
        if (StringUtils.equals((CharSequence)hbciTwoStepMechanism.getNeedchallengeklass(), (CharSequence)"J")) {
            ChallengeInfo cinfo = ChallengeInfo.getInstance();
            cinfo.applyParams(hbciJob, (AbstractHBCIJob)hktan, hbciTwoStepMechanism);
        }
        return hbciJob.getRawData();
    }

    private void hktanProcess2(HBCIDialog dialog, AbstractHBCIJob sepagv, Konto orderAccount, GVTAN2Step hktan) {
        hktan.setParam("process", "4");
        hktan.setParam("orderaccount", orderAccount);
        Optional<List> messages = Optional.ofNullable(sepagv).map(arg_0 -> ((HBCIDialog)dialog).addTask(arg_0));
        if (messages.isPresent()) {
            messages.get().add(hktan);
        } else {
            dialog.addTask((AbstractHBCIJob)hktan);
        }
    }

    public SubmitAuthorizationCodeResponse sumbitAuthorizationCode(SubmitAuthorizationCodeRequest submitAuthorizationCodeRequest) {
        HbciTanSubmit hbciTanSubmit = this.evaluateTanSubmit(submitAuthorizationCodeRequest);
        HbciPassport hbciPassport = this.createPassport(submitAuthorizationCodeRequest, hbciTanSubmit);
        HBCIDialog hbciDialog = new HBCIDialog((PinTanPassport)hbciPassport, hbciTanSubmit.getDialogId(), hbciTanSubmit.getMsgNum());
        AbstractHBCIJob paymentGV = hbciTanSubmit.getTwoStepMechanism().getProcess() == 1 ? this.submitProcess1(submitAuthorizationCodeRequest.getSepaTransaction(), hbciTanSubmit, hbciPassport, hbciDialog) : this.submitProcess2(hbciTanSubmit, hbciDialog);
        HBCIExecStatus status = hbciDialog.execute(true);
        if (!status.isOK()) {
            throw new MultibankingException(MultibankingError.HBCI_ERROR, status.getDialogStatus().getErrorMessages());
        }
        return this.createResponse(hbciTanSubmit, paymentGV, status);
    }

    private AbstractHBCIJob submitProcess1(AbstractScaTransaction transaction, HbciTanSubmit hbciTanSubmit, HbciPassport hbciPassport, HBCIDialog hbciDialog) {
        AbstractHBCIJob uebSEPAJob = this.createHbciJob(transaction, hbciPassport);
        if (hbciTanSubmit.getSepaPain() != null) {
            uebSEPAJob.getConstraints().remove("_sepapain");
            uebSEPAJob.setLowlevelParam(uebSEPAJob.getName() + ".sepapain", hbciTanSubmit.getSepaPain());
        }
        hbciDialog.addTask(uebSEPAJob);
        return uebSEPAJob;
    }

    private AbstractHBCIJob submitProcess2(HbciTanSubmit hbciTanSubmit, HBCIDialog hbciDialog) {
        AbstractHBCIJob originJob = Optional.ofNullable(hbciTanSubmit.getOriginJobName()).map(s -> {
            AbstractHBCIJob result = HBCIJobFactory.newJob((String)hbciTanSubmit.getOriginJobName(), (HBCIPassportInternal)hbciDialog.getPassport());
            result.setSegVersion(hbciTanSubmit.getOriginSegVersion());
            return result;
        }).orElse(null);
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)hbciDialog.getPassport());
        hktan.setOriginJob(originJob);
        hktan.setParam("orderref", hbciTanSubmit.getOrderRef());
        hktan.setParam("process", hbciTanSubmit.getHktanProcess() != null ? hbciTanSubmit.getHktanProcess() : "2");
        hktan.setParam("notlasttan", "N");
        hbciDialog.addTask((AbstractHBCIJob)hktan, false);
        return originJob;
    }

    private HbciTanSubmit deserializeTanSubmit(byte[] data) {
        try {
            return (HbciTanSubmit)ScaRequiredJob.objectMapper().readValue(data, HbciTanSubmit.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not deserialize HbciTanSubmit", e);
        }
    }

    Konto getDebtorAccount(AbstractScaTransaction sepaTransaction, PinTanPassport passport) {
        return Optional.ofNullable(sepaTransaction.getDebtorBankAccount()).map(bankAccount -> {
            Konto konto = passport.findAccountByAccountNumber(bankAccount.getAccountNumber());
            konto.iban = bankAccount.getIban();
            konto.bic = bankAccount.getBic();
            return konto;
        }).orElse(null);
    }

    private HbciPassport createPassport(final SubmitAuthorizationCodeRequest submitAuthorizationCodeRequest, HbciTanSubmit hbciTanSubmit) {
        HashMap<String, String> bpd = new HashMap<String, String>();
        bpd.put("Params." + hbciTanSubmit.getOriginLowLevelName() + "Par" + hbciTanSubmit.getOriginSegVersion() + ".Par" + hbciTanSubmit.getOriginLowLevelName() + ".suppformats", hbciTanSubmit.getPainVersion());
        bpd.put("Params." + hbciTanSubmit.getOriginLowLevelName() + "Par" + hbciTanSubmit.getOriginSegVersion() + ".SegHead.code", hbciTanSubmit.getHbciJobName());
        bpd.put("Params.TAN2StepPar" + hbciTanSubmit.getTwoStepMechanism().getSegversion() + ".SegHead.code", "HKTAN");
        bpd.put("BPA.numgva", "100");
        HbciPassport.State state = HbciPassport.State.fromJson(hbciTanSubmit.getPassportState());
        HbciPassport hbciPassport = HbciDialogFactory.createPassport(state, new HbciCallback(){

            @Override
            public String needTAN() {
                return submitAuthorizationCodeRequest.getTan();
            }
        });
        state.apply(hbciPassport);
        hbciPassport.setPIN(submitAuthorizationCodeRequest.getPin());
        hbciPassport.setCurrentSecMechInfo(hbciTanSubmit.getTwoStepMechanism());
        hbciPassport.setBPD(bpd);
        return hbciPassport;
    }

    private HbciTanSubmit evaluateTanSubmit(SubmitAuthorizationCodeRequest submitAuthorizationCodeRequest) {
        if (submitAuthorizationCodeRequest.getTanSubmit() instanceof HbciTanSubmit) {
            return (HbciTanSubmit)submitAuthorizationCodeRequest.getTanSubmit();
        }
        return this.deserializeTanSubmit((byte[])submitAuthorizationCodeRequest.getTanSubmit());
    }

    private SubmitAuthorizationCodeResponse createResponse(HbciTanSubmit hbciTanSubmit, AbstractHBCIJob paymentGV, HBCIExecStatus status) {
        String transactionId = Optional.ofNullable(paymentGV).map(abstractHBCIJob -> this.orderIdFromJobResult(abstractHBCIJob.getJobResult())).orElse(hbciTanSubmit.getOrderRef());
        SubmitAuthorizationCodeResponse response = new SubmitAuthorizationCodeResponse();
        response.setTransactionId(transactionId);
        if (!status.getDialogStatus().msgStatusList.isEmpty()) {
            response.setStatus(((HBCIMsgStatus)status.getDialogStatus().msgStatusList.get((int)0)).segStatus.toString());
        }
        return response;
    }

    abstract String getHbciJobName(AbstractScaTransaction.TransactionType var1);

    abstract String orderIdFromJobResult(HBCIJobResult var1);

    abstract AbstractHBCIJob createHbciJob(AbstractScaTransaction var1, PinTanPassport var2);
}

