/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci.job;

import de.adorsys.multibanking.domain.AbstractScaTransaction;
import de.adorsys.multibanking.domain.BulkPayment;
import de.adorsys.multibanking.domain.FutureBulkPayment;
import de.adorsys.multibanking.domain.SinglePayment;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVMultiUebSEPA;
import org.kapott.hbci.GV.GVTermMultiUebSEPA;
import org.kapott.hbci.GV_Result.GVRTermUeb;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class BulkPaymentJob
extends ScaRequiredJob {
    protected AbstractSEPAGV createHbciJob(AbstractScaTransaction transaction, PinTanPassport passport) {
        GVTermMultiUebSEPA sepagv;
        BulkPayment bulkPayment = (BulkPayment)transaction;
        Konto src = this.getDebtorAccount(transaction, passport);
        if (bulkPayment instanceof FutureBulkPayment) {
            sepagv = new GVTermMultiUebSEPA((HBCIPassportInternal)passport, GVTermMultiUebSEPA.getLowlevelName());
            sepagv.setParam("date", ((FutureBulkPayment)bulkPayment).getExecutionDate().toString());
        } else {
            sepagv = new GVMultiUebSEPA((HBCIPassportInternal)passport, GVMultiUebSEPA.getLowlevelName());
        }
        sepagv.setParam("src", src);
        for (int i = 0; i < bulkPayment.getPayments().size(); ++i) {
            SinglePayment payment = (SinglePayment)bulkPayment.getPayments().get(i);
            Konto dst = new Konto();
            dst.name = payment.getReceiver();
            dst.iban = payment.getReceiverIban();
            dst.bic = payment.getReceiverBic();
            sepagv.setParam("dst", Integer.valueOf(i), dst);
            sepagv.setParam("btg", Integer.valueOf(i), new Value(payment.getAmount(), payment.getCurrency()));
            if (payment.getPurpose() == null) continue;
            sepagv.setParam("usage", Integer.valueOf(i), payment.getPurpose());
        }
        sepagv.verifyConstraints();
        return sepagv;
    }

    @Override
    protected String getHbciJobName(AbstractScaTransaction.TransactionType paymentType) {
        if (paymentType == AbstractScaTransaction.TransactionType.FUTURE_BULK_PAYMENT) {
            return "TermMultiUebSEPA";
        }
        return "MultiUebSEPA";
    }

    @Override
    protected String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return paymentGV instanceof GVRTermUeb ? ((GVRTermUeb)paymentGV).getOrderId() : null;
    }
}

