/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import de.adorsys.multibanking.domain.AbstractScaTransaction;
import de.adorsys.multibanking.domain.BankAccess;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.exception.MultibankingException;
import de.adorsys.multibanking.domain.request.AbstractRequest;
import de.adorsys.multibanking.domain.request.AuthenticatePsuRequest;
import de.adorsys.multibanking.domain.request.CreateConsentRequest;
import de.adorsys.multibanking.domain.request.LoadAccountInformationRequest;
import de.adorsys.multibanking.domain.request.LoadBalanceRequest;
import de.adorsys.multibanking.domain.request.LoadBookingsRequest;
import de.adorsys.multibanking.domain.request.SubmitAuthorizationCodeRequest;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AuthorisationCodeResponse;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.response.InitiatePaymentResponse;
import de.adorsys.multibanking.domain.response.LoadAccountInformationResponse;
import de.adorsys.multibanking.domain.response.LoadBookingsResponse;
import de.adorsys.multibanking.domain.response.ScaMethodsResponse;
import de.adorsys.multibanking.domain.response.SubmitAuthorizationCodeResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.hbci.job.AccountInformationJob;
import de.adorsys.multibanking.hbci.job.BulkPaymentJob;
import de.adorsys.multibanking.hbci.job.DeleteFutureBulkPaymentJob;
import de.adorsys.multibanking.hbci.job.DeleteFutureSinglePaymentJob;
import de.adorsys.multibanking.hbci.job.DeleteStandingOrderJob;
import de.adorsys.multibanking.hbci.job.EmptyJob;
import de.adorsys.multibanking.hbci.job.ForeignPaymentJob;
import de.adorsys.multibanking.hbci.job.LoadBalanceJob;
import de.adorsys.multibanking.hbci.job.LoadBookingsJob;
import de.adorsys.multibanking.hbci.job.NewStandingOrderJob;
import de.adorsys.multibanking.hbci.job.RawSepaJob;
import de.adorsys.multibanking.hbci.job.ScaRequiredJob;
import de.adorsys.multibanking.hbci.job.SinglePaymentJob;
import de.adorsys.multibanking.hbci.job.TransferJob;
import de.adorsys.multibanking.hbci.model.HbciCallback;
import de.adorsys.multibanking.hbci.model.HbciDialogFactory;
import de.adorsys.multibanking.hbci.model.HbciDialogRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hbci4JavaBanking
implements OnlineBankingService {
    private static final Logger log = LoggerFactory.getLogger(Hbci4JavaBanking.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Map<String, Map<String, String>> bpdCache;

    public Hbci4JavaBanking() {
        this(null, false);
    }

    public Hbci4JavaBanking(boolean cacheBpd) {
        this(null, cacheBpd);
    }

    public Hbci4JavaBanking(InputStream customBankConfigInput, boolean cacheBpd) {
        if (cacheBpd) {
            this.bpdCache = new HashMap<String, Map<String, String>>();
        }
        try (InputStream inputStream = Optional.ofNullable(customBankConfigInput).orElseGet(this::getDefaultBanksInput);){
            HBCIUtils.refreshBLZList((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }

    private InputStream getDefaultBanksInput() {
        return Optional.ofNullable(HBCIUtils.class.getClassLoader().getResource("blz.properties")).map(url -> {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).orElseThrow(() -> new RuntimeException("blz.properties not exists in classpath"));
    }

    public BankApi bankApi() {
        return BankApi.HBCI;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(String bankingUrl, BankAccess bankAccess, String pin) {
        return null;
    }

    public void removeUser(String bankingUrl, BankApiUser bankApiUser) {
    }

    public ScaMethodsResponse authenticatePsu(String bankingUrl, AuthenticatePsuRequest authenticatePsuRequest) {
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(authenticatePsuRequest.getBankCode()).login(authenticatePsuRequest.getLogin()).customerId(authenticatePsuRequest.getCustomerId()).pin(authenticatePsuRequest.getPin()).build();
        HbciCallback bpdCacheCallback = this.setRequestBpdAndCreateCallback(dialogRequest.getBankCode(), dialogRequest);
        dialogRequest.setCallback(bpdCacheCallback);
        HBCIDialog dialog = this.createDialog(bankingUrl, dialogRequest);
        dialog.getMessages();
        return ScaMethodsResponse.builder().tanTransportTypes(AccountInformationJob.extractTanTransportTypes(dialog.getPassport())).build();
    }

    public LoadAccountInformationResponse loadBankAccounts(String bankingUrl, LoadAccountInformationRequest request) {
        HbciCallback bpdCacheCallback = this.setRequestBpdAndCreateCallback(request.getBankCode(), (AbstractRequest)request);
        return this.loadBankAccounts(bankingUrl, request, bpdCacheCallback);
    }

    public LoadAccountInformationResponse loadBankAccounts(String bankingUrl, LoadAccountInformationRequest request, HbciCallback callback) {
        this.checkBankExists(request.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> request.setBpd((Map)cache.get(request.getBankCode())));
        try {
            return new AccountInformationJob().loadBankAccounts(request, callback);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public InitiatePaymentResponse initiatePayment(String bankingUrl, TransactionRequest paymentRequest) {
        return null;
    }

    public void executeTransactionWithoutSca(String bankingUrl, TransactionRequest paymentRequest) {
        this.checkBankExists(paymentRequest.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> paymentRequest.setBpd((Map)cache.get(paymentRequest.getBankCode())));
        try {
            TransferJob transferJob = new TransferJob();
            transferJob.requestTransfer(paymentRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public AuthorisationCodeResponse requestAuthorizationCode(String bankingUrl, TransactionRequest transactionRequest) {
        this.checkBankExists(transactionRequest.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> transactionRequest.setBpd((Map)cache.get(transactionRequest.getBankCode())));
        try {
            ScaRequiredJob scaJob = Optional.ofNullable(transactionRequest.getTransaction()).map(sepaTransaction -> this.createScaJob(sepaTransaction.getTransactionType())).orElse(new EmptyJob());
            return scaJob.requestAuthorizationCode(transactionRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public SubmitAuthorizationCodeResponse submitAuthorizationCode(SubmitAuthorizationCodeRequest submitAuthorizationCodeRequest) {
        try {
            ScaRequiredJob scaJob = Optional.ofNullable(submitAuthorizationCodeRequest.getSepaTransaction()).map(sepaTransaction -> this.createScaJob(sepaTransaction.getTransactionType())).orElse(new EmptyJob());
            Map bpd = Optional.ofNullable(this.bpdCache).map(cache -> (Map)cache.get(submitAuthorizationCodeRequest.getBankCode())).orElse(null);
            submitAuthorizationCodeRequest.setBpd(bpd);
            return scaJob.sumbitAuthorizationCode(submitAuthorizationCodeRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public boolean accountInformationConsentRequired() {
        return false;
    }

    public void removeBankAccount(String bankingUrl, BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public LoadBookingsResponse loadBookings(String bankingUrl, LoadBookingsRequest loadBookingsRequest) {
        this.checkBankExists(loadBookingsRequest.getBankCode(), bankingUrl);
        HbciCallback bpdCacheCallback = this.setRequestBpdAndCreateCallback(loadBookingsRequest.getBankCode(), (AbstractRequest)loadBookingsRequest);
        try {
            return new LoadBookingsJob().loadBookings(loadBookingsRequest, bpdCacheCallback);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    private HbciCallback setRequestBpdAndCreateCallback(String bankCode, AbstractRequest request) {
        return Optional.ofNullable(this.bpdCache).map(cache -> {
            request.setBpd((Map)cache.get(bankCode));
            return new HbciCallback((Map)cache, bankCode){
                final /* synthetic */ Map val$cache;
                final /* synthetic */ String val$bankCode;
                {
                    this.val$cache = map;
                    this.val$bankCode = string;
                }

                @Override
                public void status(int statusTag, Object o) {
                    if (statusTag == 4) {
                        this.val$cache.put(this.val$bankCode, (Map)o);
                    }
                }
            };
        }).orElse(null);
    }

    public List<BankAccount> loadBalances(String bankingUrl, LoadBalanceRequest loadBalanceRequest) {
        this.checkBankExists(loadBalanceRequest.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> loadBalanceRequest.setBpd((Map)cache.get(loadBalanceRequest.getBankCode())));
        try {
            return LoadBalanceJob.loadBalances(loadBalanceRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public HBCIDialog createDialog(String bankingUrl, HbciDialogRequest dialogRequest) {
        this.checkBankExists(dialogRequest.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> dialogRequest.setBpd((Map)cache.get(dialogRequest.getBankCode())));
        try {
            return HbciDialogFactory.createDialog(null, dialogRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public boolean bankSupported(String bankCode) {
        BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
        return bankInfo != null && bankInfo.getPinTanVersion() != null;
    }

    public CreateConsentResponse createAccountInformationConsent(String bankingUrl, CreateConsentRequest createConsentRequest) {
        return null;
    }

    private void checkBankExists(String bankCode, String bankingUrl) {
        Optional.ofNullable(bankingUrl).ifPresent(s -> {
            BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
            if (bankInfo == null) {
                bankInfo = new BankInfo();
                bankInfo.setBlz(bankCode);
                bankInfo.setPinTanAddress(s);
                bankInfo.setPinTanVersion(HBCIVersion.HBCI_300);
                HBCIUtils.addBankInfo((BankInfo)bankInfo);
            }
        });
    }

    private ScaRequiredJob createScaJob(AbstractScaTransaction.TransactionType transactionType) {
        switch (transactionType) {
            case SINGLE_PAYMENT: 
            case FUTURE_SINGLE_PAYMENT: {
                return new SinglePaymentJob();
            }
            case FOREIGN_PAYMENT: {
                return new ForeignPaymentJob();
            }
            case BULK_PAYMENT: 
            case FUTURE_BULK_PAYMENT: {
                return new BulkPaymentJob();
            }
            case STANDING_ORDER: {
                return new NewStandingOrderJob();
            }
            case RAW_SEPA: {
                return new RawSepaJob();
            }
            case FUTURE_SINGLE_PAYMENT_DELETE: {
                return new DeleteFutureSinglePaymentJob();
            }
            case FUTURE_BULK_PAYMENT_DELETE: {
                return new DeleteFutureBulkPaymentJob();
            }
            case STANDING_ORDER_DELETE: {
                return new DeleteStandingOrderJob();
            }
            case TAN_REQUEST: 
            case DEDICATED_CONSENT: {
                return new EmptyJob();
            }
        }
        throw new IllegalArgumentException("invalid transaction type " + transactionType);
    }

    private RuntimeException handleHbciException(HBCI_Exception e) {
        Throwable processException = e;
        while (processException.getCause() != null && !(processException.getCause() instanceof MultibankingException)) {
            processException = processException.getCause();
        }
        if (processException.getCause() instanceof MultibankingException) {
            return (MultibankingException)processException.getCause();
        }
        return e;
    }
}

