/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.hbci4java.job;

import de.adorsys.hbci4java.job.ScaRequiredJob;
import domain.AbstractScaTransaction;
import domain.FutureSinglePayment;
import domain.SinglePayment;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVTermUebSEPA;
import org.kapott.hbci.GV.GVUebSEPA;
import org.kapott.hbci.GV_Result.GVRTermUeb;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class SinglePaymentJob
extends ScaRequiredJob {
    protected AbstractSEPAGV createHbciJob(AbstractScaTransaction transaction, PinTanPassport passport, String rawData) {
        GVTermUebSEPA sepagv;
        SinglePayment singlePayment = (SinglePayment)transaction;
        Konto src = this.getDebtorAccount(transaction, passport);
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic();
        if (singlePayment instanceof FutureSinglePayment) {
            sepagv = new GVTermUebSEPA((HBCIPassportInternal)passport, GVTermUebSEPA.getLowlevelName(), rawData);
            sepagv.setParam("date", ((FutureSinglePayment)singlePayment).getExecutionDate().toString());
        } else {
            sepagv = new GVUebSEPA((HBCIPassportInternal)passport, GVUebSEPA.getLowlevelName(), rawData);
        }
        sepagv.setParam("src", src);
        sepagv.setParam("dst", dst);
        sepagv.setParam("btg", new Value(singlePayment.getAmount(), singlePayment.getCurrency()));
        sepagv.setParam("usage", singlePayment.getPurpose());
        sepagv.verifyConstraints();
        return sepagv;
    }

    @Override
    protected String getHbciJobName(AbstractScaTransaction.TransactionType paymentType) {
        if (paymentType == AbstractScaTransaction.TransactionType.FUTURE_SINGLE_PAYMENT) {
            return GVTermUebSEPA.getLowlevelName();
        }
        return GVUebSEPA.getLowlevelName();
    }

    @Override
    protected String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return paymentGV instanceof GVRTermUeb ? ((GVRTermUeb)paymentGV).getOrderId() : null;
    }
}

