/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.hbci4java.job;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.hbci4java.model.HbciCallback;
import de.adorsys.hbci4java.model.HbciDialogFactory;
import de.adorsys.hbci4java.model.HbciDialogRequest;
import de.adorsys.hbci4java.model.HbciPassport;
import de.adorsys.hbci4java.model.HbciTanSubmit;
import domain.AbstractScaTransaction;
import domain.Product;
import domain.TanChallenge;
import domain.request.SubmitAuthorizationCodeRequest;
import domain.request.TransactionRequest;
import domain.response.AuthorisationCodeResponse;
import exception.HbciException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.manager.ChallengeInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIJobFactory;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;

public abstract class ScaRequiredJob {
    private static ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.findAndRegisterModules();
        return objectMapper;
    }

    public AuthorisationCodeResponse requestAuthorizationCode(TransactionRequest sepaTransactionRequest) {
        HBCIExecStatus status;
        final HbciTanSubmit hbciTanSubmit = new HbciTanSubmit();
        final AuthorisationCodeResponse response = new AuthorisationCodeResponse();
        response.setTanSubmit((Object)hbciTanSubmit);
        Optional.ofNullable(sepaTransactionRequest.getTransaction()).ifPresent(sepaTransaction -> hbciTanSubmit.setOriginJobName(this.getHbciJobName(sepaTransaction.getTransactionType())));
        HbciCallback hbciCallback = new HbciCallback(){

            @Override
            public void tanChallengeCallback(String orderRef, String challenge, String challenge_hhd_uc, HHDVersion.Type type) {
                hbciTanSubmit.setOrderRef(orderRef);
                if (challenge != null) {
                    response.setChallenge(TanChallenge.builder().title(challenge).data(challenge_hhd_uc).build());
                }
            }
        };
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(sepaTransactionRequest.getBankCode() != null ? sepaTransactionRequest.getBankCode() : sepaTransactionRequest.getBankAccess().getBankCode()).customerId(sepaTransactionRequest.getBankAccess().getBankLogin()).login(sepaTransactionRequest.getBankAccess().getBankLogin2()).hbciPassportState(sepaTransactionRequest.getBankAccess().getHbciPassportState()).pin(sepaTransactionRequest.getPin()).callback(hbciCallback).build();
        dialogRequest.setProduct(Optional.ofNullable(sepaTransactionRequest.getProduct()).map(product -> new Product(product.getName(), product.getVersion())).orElse(null));
        dialogRequest.setBpd(sepaTransactionRequest.getBpd());
        HBCIDialog dialog = HbciDialogFactory.createDialog(null, dialogRequest);
        HBCITwoStepMechanism hbciTwoStepMechanism = (HBCITwoStepMechanism)dialog.getPassport().getBankTwostepMechanisms().get(sepaTransactionRequest.getTanTransportType().getId());
        if (hbciTwoStepMechanism == null) {
            throw new HbciException("inavalid two stem mechanism: " + sepaTransactionRequest.getTanTransportType().getId());
        }
        dialog.getPassport().setCurrentSecMechInfo(hbciTwoStepMechanism);
        AbstractHBCIJob hbciJob = this.createHbciJob(sepaTransactionRequest.getTransaction(), dialog.getPassport(), null);
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)dialog.getPassport());
        hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
        if (hbciTwoStepMechanism.getProcess() == 1) {
            hbciTanSubmit.setSepaPain(this.hktanProcess1(hbciTwoStepMechanism, hbciJob, hktan));
            dialog.addTask((AbstractHBCIJob)hktan, false);
        } else {
            this.hktanProcess2(dialog, hbciJob, this.getDebtorAccount(sepaTransactionRequest.getTransaction(), dialog.getPassport()), hktan);
        }
        if (dialog.getPassport().tanMediaNeeded()) {
            hktan.setParam("tanmedia", sepaTransactionRequest.getTanTransportType().getMedium());
        }
        if (!(status = dialog.execute(false)).isOK()) {
            throw new HbciException(status.getDialogStatus().getErrorString());
        }
        hbciTanSubmit.setPassportState(new HbciPassport.State(dialog.getPassport()).toJson());
        hbciTanSubmit.setDialogId(dialog.getDialogID());
        hbciTanSubmit.setMsgNum(dialog.getMsgnum());
        hbciTanSubmit.setTanTransportType(sepaTransactionRequest.getTanTransportType());
        Optional.ofNullable(hbciJob).ifPresent(abstractSEPAGV -> hbciTanSubmit.setOriginSegVersion(abstractSEPAGV.getSegVersion()));
        return response;
    }

    public String hktanProcess1(HBCITwoStepMechanism hbciTwoStepMechanism, AbstractHBCIJob sepagv, GVTAN2Step hktan) {
        hktan.setParam("process", hbciTwoStepMechanism.getProcess());
        hktan.setParam("notlasttan", "N");
        hktan.setParam("orderhash", sepagv.createOrderHash(hbciTwoStepMechanism.getSegversion()));
        if (StringUtils.equals((CharSequence)hbciTwoStepMechanism.getNeedchallengeklass(), (CharSequence)"J")) {
            ChallengeInfo cinfo = ChallengeInfo.getInstance();
            cinfo.applyParams(sepagv, (AbstractHBCIJob)hktan, hbciTwoStepMechanism);
        }
        return sepagv.getRawData();
    }

    public void hktanProcess2(HBCIDialog dialog, AbstractHBCIJob sepagv, Konto orderAccount, GVTAN2Step hktan) {
        hktan.setParam("process", "4");
        hktan.setParam("orderaccount", orderAccount);
        Optional<List> messages = Optional.ofNullable(sepagv).map(abstractSEPAGV -> dialog.addTask(abstractSEPAGV));
        if (messages.isPresent()) {
            messages.get().add(hktan);
        } else {
            dialog.addTask((AbstractHBCIJob)hktan);
        }
    }

    public String sumbitAuthorizationCode(final SubmitAuthorizationCodeRequest submitAuthorizationCodeRequest) {
        HbciTanSubmit hbciTanSubmit = submitAuthorizationCodeRequest.getTanSubmit() instanceof HbciTanSubmit ? (HbciTanSubmit)submitAuthorizationCodeRequest.getTanSubmit() : this.deserializeTanSubmit((byte[])submitAuthorizationCodeRequest.getTanSubmit());
        HbciPassport.State state = HbciPassport.State.readJson(hbciTanSubmit.getPassportState());
        HbciPassport hbciPassport = HbciDialogFactory.createPassport(state.hbciVersion, state.blz, state.customerId, state.userId, state.hbciProduct, new HbciCallback(){

            @Override
            public String needTAN() {
                return submitAuthorizationCodeRequest.getTan();
            }
        });
        state.apply(hbciPassport);
        hbciPassport.setPIN(submitAuthorizationCodeRequest.getPin());
        HBCITwoStepMechanism hbciTwoStepMechanism = (HBCITwoStepMechanism)hbciPassport.getBankTwostepMechanisms().get(hbciTanSubmit.getTanTransportType().getId());
        hbciPassport.setCurrentSecMechInfo(hbciTwoStepMechanism);
        HBCIDialog hbciDialog = new HBCIDialog((PinTanPassport)hbciPassport, hbciTanSubmit.getDialogId(), hbciTanSubmit.getMsgNum());
        AbstractHBCIJob paymentGV = hbciTwoStepMechanism.getProcess() == 1 ? this.submitProcess1(submitAuthorizationCodeRequest.getSepaTransaction(), hbciTanSubmit, hbciPassport, hbciDialog) : this.submitProcess2(hbciTanSubmit, hbciDialog);
        HBCIExecStatus status = hbciDialog.execute(true);
        if (!status.isOK()) {
            throw new HbciException(status.getDialogStatus().getErrorString());
        }
        return Optional.ofNullable(paymentGV).map(abstractHBCIJob -> this.orderIdFromJobResult(abstractHBCIJob.getJobResult())).orElse(hbciTanSubmit.getOrderRef());
    }

    private AbstractHBCIJob submitProcess1(AbstractScaTransaction transaction, HbciTanSubmit hbciTanSubmit, HbciPassport hbciPassport, HBCIDialog hbciDialog) {
        AbstractHBCIJob uebSEPAJob = this.createHbciJob(transaction, hbciPassport, hbciTanSubmit.getSepaPain());
        hbciDialog.addTask(uebSEPAJob);
        return uebSEPAJob;
    }

    public AbstractHBCIJob submitProcess2(HbciTanSubmit hbciTanSubmit, HBCIDialog hbciDialog) {
        AbstractHBCIJob originJob = Optional.ofNullable(hbciTanSubmit.getOriginJobName()).map(s -> {
            AbstractHBCIJob result = HBCIJobFactory.newJob((String)hbciTanSubmit.getOriginJobName(), (HBCIPassportInternal)hbciDialog.getPassport());
            result.setSegVersion(hbciTanSubmit.getOriginSegVersion());
            return result;
        }).orElse(null);
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)hbciDialog.getPassport());
        hktan.setOriginJob(originJob);
        hktan.setParam("orderref", hbciTanSubmit.getOrderRef());
        hktan.setParam("process", "2");
        hktan.setParam("notlasttan", "N");
        hbciDialog.addTask((AbstractHBCIJob)hktan, false);
        return originJob;
    }

    private HbciTanSubmit deserializeTanSubmit(byte[] data) {
        try {
            return (HbciTanSubmit)ScaRequiredJob.objectMapper().readValue(data, HbciTanSubmit.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not deserialize HbciTanSubmit", e);
        }
    }

    Konto getDebtorAccount(AbstractScaTransaction sepaTransaction, PinTanPassport passport) {
        return Optional.ofNullable(sepaTransaction.getDebtorBankAccount()).map(bankAccount -> {
            Konto konto = passport.findAccountByAccountNumber(bankAccount.getAccountNumber());
            konto.iban = bankAccount.getIban();
            konto.bic = bankAccount.getBic();
            return konto;
        }).orElse(null);
    }

    abstract String getHbciJobName(AbstractScaTransaction.TransactionType var1);

    abstract String orderIdFromJobResult(HBCIJobResult var1);

    abstract AbstractHBCIJob createHbciJob(AbstractScaTransaction var1, PinTanPassport var2, String var3);
}

