/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.hbci4java.job;

import de.adorsys.hbci4java.job.ScaRequiredJob;
import de.adorsys.hbci4java.model.HbciMapping;
import domain.AbstractScaTransaction;
import domain.StandingOrder;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVDauerSEPANew;
import org.kapott.hbci.GV_Result.GVRDauerNew;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewStandingOrderJob
extends ScaRequiredJob {
    private static final Logger log = LoggerFactory.getLogger(NewStandingOrderJob.class);

    protected AbstractSEPAGV createHbciJob(AbstractScaTransaction transaction, PinTanPassport passport, String rawData) {
        StandingOrder standingOrder = (StandingOrder)transaction;
        Konto src = this.getDebtorAccount(transaction, passport);
        Konto dst = new Konto();
        dst.name = standingOrder.getOtherAccount().getOwner();
        dst.iban = standingOrder.getOtherAccount().getIban();
        dst.bic = standingOrder.getOtherAccount().getBic();
        GVDauerSEPANew gvDauerSEPANew = new GVDauerSEPANew((HBCIPassportInternal)passport, rawData);
        gvDauerSEPANew.setParam("src", src);
        gvDauerSEPANew.setParam("dst", dst);
        gvDauerSEPANew.setParam("btg", new Value(standingOrder.getAmount(), standingOrder.getCurrency()));
        gvDauerSEPANew.setParam("usage", standingOrder.getUsage());
        if (standingOrder.getFirstExecutionDate() != null) {
            gvDauerSEPANew.setParam("firstdate", standingOrder.getFirstExecutionDate().toString());
        }
        if (standingOrder.getCycle() != null) {
            gvDauerSEPANew.setParam("timeunit", HbciMapping.cycleToTimeunit(standingOrder.getCycle()));
            gvDauerSEPANew.setParam("turnus", HbciMapping.cycleToTurnus(standingOrder.getCycle()));
        }
        gvDauerSEPANew.setParam("execday", standingOrder.getExecutionDay());
        if (standingOrder.getLastExecutionDate() != null) {
            gvDauerSEPANew.setParam("lastdate", standingOrder.getLastExecutionDate().toString());
        }
        gvDauerSEPANew.verifyConstraints();
        return gvDauerSEPANew;
    }

    @Override
    protected String getHbciJobName(AbstractScaTransaction.TransactionType paymentType) {
        return GVDauerSEPANew.getLowlevelName();
    }

    @Override
    protected String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return ((GVRDauerNew)paymentGV).getOrderId();
    }
}

