/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.hbci4java.job;

import de.adorsys.hbci4java.job.AccountInformationJob;
import de.adorsys.hbci4java.model.HbciDialogFactory;
import de.adorsys.hbci4java.model.HbciDialogRequest;
import de.adorsys.hbci4java.model.HbciMapping;
import de.adorsys.hbci4java.model.HbciPassport;
import domain.BalancesReport;
import domain.BankAccount;
import domain.BankApi;
import domain.Booking;
import domain.Product;
import domain.request.LoadBookingsRequest;
import domain.response.LoadBookingsResponse;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVDauerSEPAList;
import org.kapott.hbci.GV.GVKUmsAll;
import org.kapott.hbci.GV.GVKUmsAllCamt;
import org.kapott.hbci.GV.GVSaldoReq;
import org.kapott.hbci.GV_Result.GVRDauerList;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBookingsJob {
    private static final Logger log = LoggerFactory.getLogger(LoadBookingsJob.class);

    public static LoadBookingsResponse loadBookings(LoadBookingsRequest request) {
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(request.getBankCode() != null ? request.getBankCode() : request.getBankAccess().getBankCode()).customerId(request.getBankAccess().getBankLogin()).login(request.getBankAccess().getBankLogin2()).hbciPassportState(request.getBankAccess().getHbciPassportState()).pin(request.getPin()).build();
        dialogRequest.setProduct(Optional.ofNullable(request.getProduct()).map(product -> new Product(product.getName(), product.getVersion())).orElse(null));
        dialogRequest.setBpd(request.getBpd());
        HBCIDialog dialog = HbciDialogFactory.createDialog(null, dialogRequest);
        Konto account = LoadBookingsJob.createAccount(dialog, request.getBankAccount());
        AbstractHBCIJob bookingsJob = LoadBookingsJob.createBookingsJob(dialog, request, account);
        Optional<AbstractHBCIJob> balanceJob = request.isWithBalance() ? Optional.of(LoadBookingsJob.createBalanceJob(dialog, account)) : Optional.empty();
        Optional<AbstractHBCIJob> standingOrdersJob = request.isWithStandingOrders() ? Optional.of(LoadBookingsJob.createStandingOrdersJob(dialog, account)) : Optional.empty();
        HBCIExecStatus dialogStatus = dialog.execute(true);
        if (!dialogStatus.isOK()) {
            log.warn(dialogStatus.getErrorString());
        }
        if (bookingsJob.getJobResult().getJobStatus().hasErrors()) {
            log.error("Bookings job not OK");
            throw new HBCI_Exception(bookingsJob.getJobResult().getJobStatus().getErrorString());
        }
        List standingOrders = standingOrdersJob.map(abstractHBCIJob -> HbciMapping.createStandingOrders((GVRDauerList)abstractHBCIJob.getJobResult())).orElse(null);
        BalancesReport bankAccountBalance = balanceJob.map(abstractHBCIJob -> HbciMapping.createBalance((GVRSaldoReq)abstractHBCIJob.getJobResult())).orElse(null);
        ArrayList bookingList = null;
        String raw = null;
        GVRKUms bookingsResult = (GVRKUms)bookingsJob.getJobResult();
        if (request.getRawResponseType() != null) {
            raw = bookingsResult.getRaw();
        } else {
            bookingList = HbciMapping.createBookings(bookingsResult).stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<Booking>(Comparator.comparing(Booking::getExternalId))), ArrayList::new));
        }
        if (request.isWithTanTransportTypes()) {
            request.getBankAccess().setTanTransportTypes(new HashMap());
            request.getBankAccess().getTanTransportTypes().put(BankApi.HBCI, AccountInformationJob.extractTanTransportTypes(dialog.getPassport()));
        }
        return LoadBookingsResponse.builder().hbciPassportState(new HbciPassport.State(dialog.getPassport()).toJson()).bookings((List)bookingList).rawData(raw).bankAccountBalance(bankAccountBalance).standingOrders(standingOrders).build();
    }

    private static AbstractHBCIJob createStandingOrdersJob(HBCIDialog dialog, Konto account) {
        GVDauerSEPAList standingOrdersJob = null;
        if (dialog.getPassport().jobSupported("DauerSEPAList")) {
            standingOrdersJob = new GVDauerSEPAList((HBCIPassportInternal)dialog.getPassport());
            standingOrdersJob.setParam("src", account);
            dialog.addTask((AbstractHBCIJob)standingOrdersJob);
        }
        return standingOrdersJob;
    }

    private static AbstractHBCIJob createBookingsJob(HBCIDialog dialog, LoadBookingsRequest loadBookingsRequest, Konto account) {
        AbstractHBCIJob bookingsJob = Optional.ofNullable(loadBookingsRequest.getRawResponseType()).map(rawResponseType -> {
            if (rawResponseType == LoadBookingsRequest.RawResponseType.CAMT) {
                return new GVKUmsAllCamt((HBCIPassportInternal)dialog.getPassport());
            }
            return new GVKUmsAll((HBCIPassportInternal)dialog.getPassport());
        }).orElseGet(() -> new GVKUmsAll((HBCIPassportInternal)dialog.getPassport()));
        bookingsJob.setParam("my", account);
        Optional.ofNullable(loadBookingsRequest.getDateFrom()).ifPresent(localDate -> bookingsJob.setParam("startdate", Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant())));
        Optional.ofNullable(loadBookingsRequest.getDateTo()).ifPresent(localDate -> bookingsJob.setParam("enddate", Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant())));
        dialog.addTask(bookingsJob);
        return bookingsJob;
    }

    private static AbstractHBCIJob createBalanceJob(HBCIDialog dialog, Konto account) {
        GVSaldoReq balanceJob = new GVSaldoReq((HBCIPassportInternal)dialog.getPassport());
        balanceJob.setParam("my", account);
        dialog.addTask((AbstractHBCIJob)balanceJob);
        return balanceJob;
    }

    private static Konto createAccount(HBCIDialog dialog, BankAccount bankAccount) {
        Konto account = dialog.getPassport().findAccountByAccountNumber(bankAccount.getAccountNumber());
        account.iban = bankAccount.getIban();
        account.bic = bankAccount.getBic();
        return account;
    }

    private static boolean initFailed(HBCIExecStatus status) {
        return Stream.of(StringUtils.split((String)status.getErrorString(), (String)System.getProperty("line.separator"))).anyMatch(line -> line.charAt(0) == '9');
    }
}

