/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.hbci4java.job;

import de.adorsys.hbci4java.job.ScaRequiredJob;
import domain.AbstractScaTransaction;
import domain.BulkPayment;
import domain.FutureBulkPayment;
import domain.SinglePayment;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVMultiUebSEPA;
import org.kapott.hbci.GV.GVTermMultiUebSEPA;
import org.kapott.hbci.GV.GVUebSEPA;
import org.kapott.hbci.GV_Result.GVRTermUeb;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class BulkPaymentJob
extends ScaRequiredJob {
    protected AbstractSEPAGV createHbciJob(AbstractScaTransaction transaction, PinTanPassport passport, String rawData) {
        GVTermMultiUebSEPA sepagv;
        BulkPayment bulkPayment = (BulkPayment)transaction;
        Konto src = this.getDebtorAccount(transaction, passport);
        if (bulkPayment instanceof FutureBulkPayment) {
            sepagv = new GVTermMultiUebSEPA((HBCIPassportInternal)passport, GVTermMultiUebSEPA.getLowlevelName(), rawData);
            sepagv.setParam("date", ((FutureBulkPayment)bulkPayment).getExecutionDate().toString());
        } else {
            sepagv = new GVMultiUebSEPA((HBCIPassportInternal)passport, GVUebSEPA.getLowlevelName(), rawData);
        }
        sepagv.setParam("src", src);
        for (int i = 0; i < bulkPayment.getPayments().size(); ++i) {
            SinglePayment payment = (SinglePayment)bulkPayment.getPayments().get(i);
            Konto dst = new Konto();
            dst.name = payment.getReceiver();
            dst.iban = payment.getReceiverIban();
            dst.bic = payment.getReceiverBic();
            sepagv.setParam("dst", Integer.valueOf(i), dst);
            sepagv.setParam("btg", Integer.valueOf(i), new Value(payment.getAmount(), payment.getCurrency()));
            sepagv.setParam("usage", Integer.valueOf(i), payment.getPurpose());
        }
        sepagv.verifyConstraints();
        return sepagv;
    }

    @Override
    protected String getHbciJobName(AbstractScaTransaction.TransactionType paymentType) {
        if (paymentType == AbstractScaTransaction.TransactionType.FUTURE_BULK_PAYMENT) {
            return "TermMultiUebSEPA";
        }
        return "MultiUebSEPA";
    }

    @Override
    protected String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return paymentGV instanceof GVRTermUeb ? ((GVRTermUeb)paymentGV).getOrderId() : null;
    }
}

