/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.hbci4java;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import de.adorsys.hbci4java.job.AccountInformationJob;
import de.adorsys.hbci4java.job.BulkPaymentJob;
import de.adorsys.hbci4java.job.DeleteFutureBulkPaymentJob;
import de.adorsys.hbci4java.job.DeleteFutureSinglePaymentJob;
import de.adorsys.hbci4java.job.DeleteStandingOrderJob;
import de.adorsys.hbci4java.job.EmptyJob;
import de.adorsys.hbci4java.job.ForeignPaymentJob;
import de.adorsys.hbci4java.job.LoadBalanceJob;
import de.adorsys.hbci4java.job.LoadBookingsJob;
import de.adorsys.hbci4java.job.NewStandingOrderJob;
import de.adorsys.hbci4java.job.RawSepaJob;
import de.adorsys.hbci4java.job.ScaRequiredJob;
import de.adorsys.hbci4java.job.SinglePaymentJob;
import de.adorsys.hbci4java.job.TransferJob;
import de.adorsys.hbci4java.model.HbciCallback;
import de.adorsys.hbci4java.model.HbciDialogFactory;
import de.adorsys.hbci4java.model.HbciDialogRequest;
import domain.AbstractScaTransaction;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.request.AuthenticatePsuRequest;
import domain.request.CreateConsentRequest;
import domain.request.LoadAccountInformationRequest;
import domain.request.LoadBalanceRequest;
import domain.request.LoadBookingsRequest;
import domain.request.SubmitAuthorizationCodeRequest;
import domain.request.TransactionRequest;
import domain.response.AuthorisationCodeResponse;
import domain.response.CreateConsentResponse;
import domain.response.InitiatePaymentResponse;
import domain.response.LoadAccountInformationResponse;
import domain.response.LoadBookingsResponse;
import domain.response.ScaMethodsResponse;
import exception.InvalidPinException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spi.OnlineBankingService;

public class Hbci4JavaBanking
implements OnlineBankingService {
    private static final Logger log = LoggerFactory.getLogger(Hbci4JavaBanking.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Map<String, Map<String, String>> bpdCache;

    public Hbci4JavaBanking() {
        this(null, false);
    }

    public Hbci4JavaBanking(boolean cacheBpd) {
        this(null, cacheBpd);
    }

    public Hbci4JavaBanking(InputStream customBankConfigInput, boolean cacheBpd) {
        if (cacheBpd) {
            this.bpdCache = new HashMap<String, Map<String, String>>();
        }
        try (InputStream inputStream = Optional.ofNullable(customBankConfigInput).orElseGet(this::getDefaultBanksInput);){
            HBCIUtils.refreshBLZList((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }

    private InputStream getDefaultBanksInput() {
        return Optional.ofNullable(HBCIUtils.class.getClassLoader().getResource("blz.properties")).map(url -> {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).orElseThrow(() -> new RuntimeException("blz.properties not exists in classpath"));
    }

    public BankApi bankApi() {
        return BankApi.HBCI;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(String bankingUrl, BankAccess bankAccess, String pin) {
        return null;
    }

    public void removeUser(String bankingUrl, BankApiUser bankApiUser) {
    }

    public ScaMethodsResponse authenticatePsu(String bankingUrl, AuthenticatePsuRequest authenticatePsuRequest) {
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(authenticatePsuRequest.getBankCode()).login(authenticatePsuRequest.getLogin()).customerId(authenticatePsuRequest.getCustomerId()).pin(authenticatePsuRequest.getPin()).build();
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> dialogRequest.setCallback(new HbciCallback((Map)cache, authenticatePsuRequest){
            final /* synthetic */ Map val$cache;
            final /* synthetic */ AuthenticatePsuRequest val$authenticatePsuRequest;
            {
                this.val$cache = map;
                this.val$authenticatePsuRequest = authenticatePsuRequest;
            }

            @Override
            public void status(int statusTag, Object o) {
                if (statusTag == 4) {
                    this.val$cache.put(this.val$authenticatePsuRequest.getBankCode(), (Map)o);
                }
            }
        }));
        HBCIDialog dialog = this.createDialog(bankingUrl, dialogRequest);
        return ScaMethodsResponse.builder().tanTransportTypes(AccountInformationJob.extractTanTransportTypes(dialog.getPassport())).build();
    }

    public LoadAccountInformationResponse loadBankAccounts(String bankingUrl, LoadAccountInformationRequest request) {
        return this.loadBankAccounts(bankingUrl, request, null);
    }

    public LoadAccountInformationResponse loadBankAccounts(String bankingUrl, LoadAccountInformationRequest request, HbciCallback callback) {
        this.checkBankExists(request.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> request.setBpd((Map)cache.get(request.getBankCode())));
        try {
            return AccountInformationJob.loadBankAccounts(request, callback);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public InitiatePaymentResponse initiatePayment(String bankingUrl, TransactionRequest paymentRequest) {
        return null;
    }

    public void executeTransactionWithoutSca(String bankingUrl, TransactionRequest paymentRequest) {
        this.checkBankExists(paymentRequest.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> paymentRequest.setBpd((Map)cache.get(paymentRequest.getBankCode())));
        try {
            TransferJob transferJob = new TransferJob();
            transferJob.requestTransfer(paymentRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public AuthorisationCodeResponse requestAuthorizationCode(String bankingUrl, TransactionRequest transactionRequest) {
        this.checkBankExists(transactionRequest.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> transactionRequest.setBpd((Map)cache.get(transactionRequest.getBankCode())));
        try {
            ScaRequiredJob scaJob = Optional.ofNullable(transactionRequest.getTransaction()).map(sepaTransaction -> this.createScaJob(sepaTransaction.getTransactionType())).orElse(new EmptyJob());
            return scaJob.requestAuthorizationCode(transactionRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public String submitAuthorizationCode(SubmitAuthorizationCodeRequest submitAuthorizationCodeRequest) {
        try {
            ScaRequiredJob scaJob = Optional.ofNullable(submitAuthorizationCodeRequest.getSepaTransaction()).map(sepaTransaction -> this.createScaJob(sepaTransaction.getTransactionType())).orElse(new EmptyJob());
            return scaJob.sumbitAuthorizationCode(submitAuthorizationCodeRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public void removeBankAccount(String bankingUrl, BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public LoadBookingsResponse loadBookings(String bankingUrl, LoadBookingsRequest loadBookingsRequest) {
        this.checkBankExists(loadBookingsRequest.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> loadBookingsRequest.setBpd((Map)cache.get(loadBookingsRequest.getBankCode())));
        try {
            return LoadBookingsJob.loadBookings(loadBookingsRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public List<BankAccount> loadBalances(String bankingUrl, LoadBalanceRequest loadBalanceRequest) {
        this.checkBankExists(loadBalanceRequest.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> loadBalanceRequest.setBpd((Map)cache.get(loadBalanceRequest.getBankCode())));
        try {
            return LoadBalanceJob.loadBalances(loadBalanceRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public HBCIDialog createDialog(String bankingUrl, HbciDialogRequest dialogRequest) {
        this.checkBankExists(dialogRequest.getBankCode(), bankingUrl);
        Optional.ofNullable(this.bpdCache).ifPresent(cache -> dialogRequest.setBpd((Map)cache.get(dialogRequest.getBankCode())));
        try {
            return HbciDialogFactory.createDialog(null, dialogRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public boolean bankSupported(String bankCode) {
        BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
        return bankInfo != null && bankInfo.getPinTanVersion() != null;
    }

    public boolean accountInformationConsentRequired(BankApiUser bankApiUser, String accountReference) {
        return false;
    }

    public CreateConsentResponse createAccountInformationConsent(String bankingUrl, CreateConsentRequest startScaRequest) {
        return null;
    }

    private void checkBankExists(String bankCode, String bankingUrl) {
        Optional.ofNullable(bankingUrl).ifPresent(s -> {
            BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
            if (bankInfo == null) {
                bankInfo = new BankInfo();
                bankInfo.setBlz(bankCode);
                bankInfo.setPinTanAddress(s);
                bankInfo.setPinTanVersion(HBCIVersion.HBCI_300);
                HBCIUtils.addBankInfo((BankInfo)bankInfo);
            }
        });
    }

    private ScaRequiredJob createScaJob(AbstractScaTransaction.TransactionType transactionType) {
        switch (transactionType) {
            case SINGLE_PAYMENT: 
            case FUTURE_SINGLE_PAYMENT: {
                return new SinglePaymentJob();
            }
            case FOREIGN_PAYMENT: {
                return new ForeignPaymentJob();
            }
            case BULK_PAYMENT: 
            case FUTURE_BULK_PAYMENT: {
                return new BulkPaymentJob();
            }
            case STANDING_ORDER: {
                return new NewStandingOrderJob();
            }
            case RAW_SEPA: {
                return new RawSepaJob();
            }
            case FUTURE_SINGLE_PAYMENT_DELETE: {
                return new DeleteFutureSinglePaymentJob();
            }
            case FUTURE_BULK_PAYMENT_DELETE: {
                return new DeleteFutureBulkPaymentJob();
            }
            case STANDING_ORDER_DELETE: {
                return new DeleteStandingOrderJob();
            }
            case TAN_REQUEST: 
            case DEDICATED_CONSENT: {
                return new EmptyJob();
            }
        }
        throw new IllegalArgumentException("invalid transaction type " + transactionType);
    }

    private RuntimeException handleHbciException(HBCI_Exception e) {
        Throwable processException = e;
        while (processException.getCause() != null && !(processException.getCause() instanceof InvalidPinException)) {
            processException = processException.getCause();
        }
        if (processException.getCause() instanceof InvalidPinException) {
            return (InvalidPinException)processException.getCause();
        }
        return e;
    }
}

