/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import hbci4java.model.HbciCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kapott.hbci.GV_Result.GVRTANMediaList;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.manager.HBCIProduct;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.passport.PinTanPassport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbciPassport
extends PinTanPassport {
    private static final Logger log = LoggerFactory.getLogger(HbciPassport.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public HbciPassport(String hbciversion, Map<String, String> properties, HbciCallback hbciCallback, HBCIProduct hbciProduct) {
        super(hbciversion, properties, (HBCICallback)(hbciCallback != null ? hbciCallback : new HbciCallback()), hbciProduct);
    }

    public HbciPassport clone() {
        HbciPassport passport = new HbciPassport(this.getHBCIVersion(), this.getProperties(), null, this.getHbciProduct());
        passport.setCountry(this.getCountry());
        passport.setHost(this.getHost());
        passport.setPort(this.getPort());
        passport.setUserId(this.getUserId());
        passport.setSysId(this.getSysId());
        passport.setBPD(this.getBPD());
        passport.setUPD(this.getUPD());
        passport.setCustomerId(this.getCustomerId());
        passport.setUserTwostepMechanisms(this.getUserTwostepMechanisms());
        passport.setPIN(this.getPIN());
        return passport;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class State {
        public HBCIProduct hbciProduct;
        public String hbciVersion;
        public String customerId;
        public String blz;
        public String userId;
        public String country;
        public String host;
        public int port;
        public String sysId;
        public HashMap<String, String> bpd;
        public HashMap<String, String> upd;
        public List<String> allowedTwostepMechanisms;
        public List<GVRTANMediaList.TANMediaInfo> tanMedias;
        public HBCITwoStepMechanism currentSecMechInfo;

        State() {
        }

        public State(PinTanPassport passport) {
            this.country = passport.getCountry();
            this.host = passport.getHost();
            this.port = passport.getPort();
            this.blz = passport.getBLZ();
            this.userId = passport.getUserId();
            this.sysId = passport.getSysId();
            this.hbciVersion = passport.getHBCIVersion();
            this.customerId = passport.getCustomerId();
            this.allowedTwostepMechanisms = passport.getUserTwostepMechanisms();
            this.bpd = (HashMap)passport.getBPD();
            this.upd = (HashMap)passport.getUPD();
            this.tanMedias = passport.getTanMedias();
            this.currentSecMechInfo = passport.getCurrentSecMechInfo();
            this.hbciProduct = passport.getHbciProduct();
        }

        public static State readJson(String s) {
            try {
                return (State)OBJECT_MAPPER.readValue(s, State.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void apply(HbciPassport passport) {
            passport.setCountry(this.country);
            passport.setHost(this.host);
            passport.setPort(this.port);
            passport.setUserId(this.userId);
            passport.setSysId(this.sysId);
            passport.setBPD(this.bpd == null ? null : (Map)this.bpd.clone());
            passport.setUPD(this.upd == null ? null : (Map)this.upd.clone());
            passport.setCustomerId(this.customerId);
            passport.setUserTwostepMechanisms(new ArrayList<String>(this.allowedTwostepMechanisms));
            passport.setTanMedias(this.tanMedias);
            passport.setCurrentSecMechInfo(this.currentSecMechInfo);
        }

        public String toJson() {
            try {
                return OBJECT_MAPPER.writeValueAsString((Object)this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

