/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.job;

import domain.BankAccount;
import domain.Product;
import domain.request.LoadBalanceRequest;
import hbci4java.model.HbciDialogFactory;
import hbci4java.model.HbciDialogRequest;
import hbci4java.model.HbciMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVSaldoReq;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalanceJob {
    private static final Logger log = LoggerFactory.getLogger(LoadBalanceJob.class);

    public static List<BankAccount> loadBalances(LoadBalanceRequest loadBalanceRequest) {
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(loadBalanceRequest.getBankCode() != null ? loadBalanceRequest.getBankCode() : loadBalanceRequest.getBankAccess().getBankCode()).customerId(loadBalanceRequest.getBankAccess().getBankLogin()).login(loadBalanceRequest.getBankAccess().getBankLogin2()).hbciPassportState(loadBalanceRequest.getBankAccess().getHbciPassportState()).pin(loadBalanceRequest.getPin()).build();
        dialogRequest.setProduct(Optional.ofNullable(loadBalanceRequest.getProduct()).map(product -> new Product(product.getName(), product.getVersion())).orElse(null));
        dialogRequest.setBpd(loadBalanceRequest.getBpd());
        HBCIDialog dialog = HbciDialogFactory.createDialog(null, dialogRequest);
        HashMap jobs = new HashMap();
        loadBalanceRequest.getBankAccounts().stream().forEach(bankAccount -> {
            Konto account = LoadBalanceJob.createAccount(dialog, bankAccount);
            jobs.put(LoadBalanceJob.createBalanceJob(dialog, account), bankAccount);
        });
        HBCIExecStatus status = dialog.execute(true);
        if (!status.isOK()) {
            log.error("Status of balance job not OK " + status);
            if (LoadBalanceJob.initFailed(status)) {
                throw new HBCI_Exception(status.getErrorString());
            }
        }
        ArrayList<BankAccount> bankAccounts = new ArrayList<BankAccount>();
        jobs.keySet().stream().forEach(job -> {
            if (job.getJobResult().getJobStatus().hasErrors()) {
                log.error("Balance job not OK");
                throw new HBCI_Exception(job.getJobResult().getJobStatus().getErrorString());
            }
            BankAccount bankAccount = (BankAccount)jobs.get(job);
            bankAccount.setBalances(HbciMapping.createBalance((GVRSaldoReq)job.getJobResult()));
            bankAccounts.add(bankAccount);
        });
        return bankAccounts;
    }

    private static AbstractHBCIJob createBalanceJob(HBCIDialog dialog, Konto konto) {
        GVSaldoReq balanceJob = new GVSaldoReq((HBCIPassportInternal)dialog.getPassport());
        balanceJob.setParam("my", konto);
        dialog.addTask((AbstractHBCIJob)balanceJob);
        return balanceJob;
    }

    private static Konto createAccount(HBCIDialog dialog, BankAccount bankAccount) {
        Konto account = dialog.getPassport().findAccountByAccountNumber(bankAccount.getAccountNumber());
        account.iban = bankAccount.getIban();
        account.bic = bankAccount.getBic();
        return account;
    }

    private static boolean initFailed(HBCIExecStatus status) {
        return Stream.of(StringUtils.split((String)status.getErrorString(), (String)System.getProperty("line.separator"))).anyMatch(line -> line.charAt(0) == '9');
    }
}

