/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.job;

import domain.AbstractScaTransaction;
import domain.FutureSinglePayment;
import hbci4java.job.ScaRequiredJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVTermUebSEPADel;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class DeleteFutureSinglePaymentJob
extends ScaRequiredJob {
    private String jobName;

    protected AbstractSEPAGV createHbciJob(AbstractScaTransaction transaction, PinTanPassport passport, String rawData) {
        FutureSinglePayment singlePayment = (FutureSinglePayment)transaction;
        Konto src = this.getDebtorAccount(transaction, passport);
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic();
        this.jobName = GVTermUebSEPADel.getLowlevelName();
        GVTermUebSEPADel sepadelgv = new GVTermUebSEPADel((HBCIPassportInternal)passport, this.jobName, rawData);
        sepadelgv.setParam("orderid", singlePayment.getOrderId());
        sepadelgv.setParam("date", singlePayment.getExecutionDate().toString());
        sepadelgv.setParam("src", src);
        sepadelgv.setParam("dst", dst);
        sepadelgv.setParam("btg", new Value(singlePayment.getAmount()));
        sepadelgv.setParam("usage", singlePayment.getPurpose());
        sepadelgv.verifyConstraints();
        return sepadelgv;
    }

    @Override
    protected String getHbciJobName(AbstractScaTransaction.TransactionType paymentType) {
        return this.jobName;
    }

    @Override
    protected String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return null;
    }
}

