/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.job;

import domain.BankAccount;
import domain.BankApi;
import domain.Product;
import domain.TanTransportType;
import domain.request.LoadAccountInformationRequest;
import domain.response.LoadAccountInformationResponse;
import exception.HbciException;
import hbci4java.model.HbciCallback;
import hbci4java.model.HbciDialogFactory;
import hbci4java.model.HbciDialogRequest;
import hbci4java.model.HbciMapping;
import hbci4java.model.HbciPassport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.GVSEPAInfo;
import org.kapott.hbci.GV.GVTANMediaList;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountInformationJob {
    private static final Logger log = LoggerFactory.getLogger(AccountInformationJob.class);

    public static LoadAccountInformationResponse loadBankAccounts(LoadAccountInformationRequest request, HbciCallback callback) {
        HBCIExecStatus status;
        log.info("Loading account list for bank [{}]", (Object)request.getBankCode());
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(request.getBankCode() != null ? request.getBankCode() : request.getBankAccess().getBankCode()).customerId(request.getBankAccess().getBankLogin()).login(request.getBankAccess().getBankLogin2()).hbciPassportState(request.getBankAccess().getHbciPassportState()).pin(request.getPin()).callback(callback).build();
        dialogRequest.setProduct(Optional.ofNullable(request.getProduct()).map(product -> new Product(product.getName(), product.getVersion())).orElse(null));
        dialogRequest.setBpd(request.getBpd());
        HBCIDialog dialog = HbciDialogFactory.createDialog(null, dialogRequest);
        if (!dialog.getPassport().jobSupported("SEPAInfo")) {
            throw new RuntimeException("SEPAInfo job not supported");
        }
        log.info("fetching SEPA informations");
        dialog.addTask((AbstractHBCIJob)new GVSEPAInfo((HBCIPassportInternal)dialog.getPassport()));
        if (request.isUpdateTanTransportTypes() && dialog.getPassport().jobSupported("TANMediaList")) {
            log.info("fetching TAN media list");
            dialog.addTask((AbstractHBCIJob)new GVTANMediaList((HBCIPassportInternal)dialog.getPassport()));
        }
        if (!(status = dialog.execute(true)).isOK()) {
            throw new HbciException(status.getDialogStatus().getErrorString());
        }
        request.getBankAccess().setBankName(dialog.getPassport().getInstName());
        ArrayList<BankAccount> hbciAccounts = new ArrayList<BankAccount>();
        for (Konto konto : dialog.getPassport().getAccounts()) {
            BankAccount bankAccount = HbciMapping.toBankAccount(konto);
            bankAccount.externalId(BankApi.HBCI, UUID.randomUUID().toString());
            bankAccount.bankName(request.getBankAccess().getBankName());
            hbciAccounts.add(bankAccount);
        }
        if (request.isUpdateTanTransportTypes()) {
            AccountInformationJob.extractTanTransportTypes(dialog.getPassport()).ifPresent(tanTransportTypes -> {
                if (request.getBankAccess().getTanTransportTypes() == null) {
                    request.getBankAccess().setTanTransportTypes(new HashMap());
                }
                request.getBankAccess().getTanTransportTypes().put(BankApi.HBCI, tanTransportTypes);
            });
        }
        request.getBankAccess().setHbciPassportState(new HbciPassport.State(dialog.getPassport()).toJson());
        return LoadAccountInformationResponse.builder().bankAccess(request.getBankAccess()).bankAccounts(hbciAccounts).build();
    }

    public static Optional<List<TanTransportType>> extractTanTransportTypes(PinTanPassport hbciPassport) {
        return Optional.ofNullable(hbciPassport.getUPD()).map(upd -> hbciPassport.getUserTwostepMechanisms().stream().map(id -> (HBCITwoStepMechanism)hbciPassport.getBankTwostepMechanisms().get(id)).filter(Objects::nonNull).map(hbciTwoStepMechanism -> TanTransportType.builder().id(hbciTwoStepMechanism.getSecfunc()).name(hbciTwoStepMechanism.getName()).inputInfo(hbciTwoStepMechanism.getInputinfo()).medium(hbciPassport.getTanMedia(hbciTwoStepMechanism.getId()) != null ? hbciPassport.getTanMedia((String)hbciTwoStepMechanism.getId()).mediaName : null).build()).collect(Collectors.toList()));
    }
}

