/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.job;

import domain.AbstractPayment;
import domain.SinglePayment;
import hbci4java.job.AbstractPaymentJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVTermUebSEPA;
import org.kapott.hbci.GV.GVUebSEPA;
import org.kapott.hbci.GV_Result.GVRTermUeb;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class SinglePaymentJob
extends AbstractPaymentJob {
    @Override
    protected AbstractSEPAGV createPaymentJob(AbstractPayment payment, PinTanPassport passport, String sepaPain) {
        GVTermUebSEPA sepagv;
        SinglePayment singlePayment = (SinglePayment)payment;
        Konto src = passport.findAccountByAccountNumber(payment.getSenderAccountNumber());
        src.iban = payment.getSenderIban();
        src.bic = payment.getSenderBic();
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic();
        if (singlePayment.getExecutionDate() != null) {
            sepagv = new GVTermUebSEPA((HBCIPassportInternal)passport, GVTermUebSEPA.getLowlevelName(), sepaPain);
            sepagv.setParam("date", singlePayment.getExecutionDate().toString());
        } else {
            sepagv = new GVUebSEPA((HBCIPassportInternal)passport, GVUebSEPA.getLowlevelName(), sepaPain);
        }
        sepagv.setParam("src", src);
        sepagv.setParam("dst", dst);
        sepagv.setParam("btg", new Value(singlePayment.getAmount()));
        sepagv.setParam("usage", singlePayment.getPurpose());
        sepagv.verifyConstraints();
        return sepagv;
    }

    @Override
    protected String getJobName(AbstractPayment.PaymentType paymentType) {
        if (paymentType == AbstractPayment.PaymentType.FUTURE_PAYMENT) {
            return GVTermUebSEPA.getLowlevelName();
        }
        return GVUebSEPA.getLowlevelName();
    }

    @Override
    protected String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return paymentGV instanceof GVRTermUeb ? ((GVRTermUeb)paymentGV).getOrderId() : null;
    }
}

