/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.job;

import domain.AbstractPayment;
import domain.request.SubmitPaymentRequest;
import exception.HbciException;
import hbci4java.model.HbciCallback;
import hbci4java.model.HbciDialogFactory;
import hbci4java.model.HbciPassport;
import hbci4java.model.HbciTanSubmit;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.manager.ChallengeInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIJobFactory;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;

public abstract class AbstractTanProcessJob {
    public void hktanProcess1(HbciTanSubmit hbciTanSubmit, HBCITwoStepMechanism hbciTwoStepMechanism, AbstractSEPAGV sepagv, GVTAN2Step hktan) {
        hktan.setParam("process", hbciTwoStepMechanism.getProcess());
        hktan.setParam("notlasttan", "N");
        hktan.setParam("orderhash", sepagv.createOrderHash(hbciTwoStepMechanism.getSegversion()));
        hbciTanSubmit.setSepaPain(sepagv.getPainXml());
        if (StringUtils.equals((CharSequence)hbciTwoStepMechanism.getNeedchallengeklass(), (CharSequence)"J")) {
            ChallengeInfo cinfo = ChallengeInfo.getInstance();
            cinfo.applyParams((AbstractHBCIJob)sepagv, (AbstractHBCIJob)hktan, hbciTwoStepMechanism);
        }
    }

    public void hktanProcess2(HBCIDialog dialog, AbstractSEPAGV sepagv, Konto orderAccount, GVTAN2Step hktan) {
        hktan.setParam("process", "4");
        hktan.setParam("orderaccount", orderAccount);
        Optional<List> messages = Optional.ofNullable(sepagv).map(abstractSEPAGV -> dialog.addTask((AbstractHBCIJob)abstractSEPAGV));
        if (messages.isPresent()) {
            messages.get().add(hktan);
        } else {
            dialog.addTask((AbstractHBCIJob)hktan);
        }
    }

    public String submit(final SubmitPaymentRequest submitPaymentRequest) {
        HbciTanSubmit hbciTanSubmit = (HbciTanSubmit)submitPaymentRequest.getTanSubmit();
        HbciPassport.State state = HbciPassport.State.readJson(hbciTanSubmit.getPassportState());
        HbciPassport hbciPassport = HbciDialogFactory.createPassport(state.hbciVersion, state.blz, state.customerId, state.userId, state.hbciProduct, new HbciCallback(){

            @Override
            public String needTAN() {
                return submitPaymentRequest.getTan();
            }
        });
        state.apply(hbciPassport);
        hbciPassport.setPIN(submitPaymentRequest.getPin());
        HBCITwoStepMechanism hbciTwoStepMechanism = (HBCITwoStepMechanism)hbciPassport.getBankTwostepMechanisms().get(submitPaymentRequest.getTanTransportType().getId());
        hbciPassport.setCurrentSecMechInfo(hbciTwoStepMechanism);
        HBCIDialog hbciDialog = new HBCIDialog((PinTanPassport)hbciPassport, hbciTanSubmit.getDialogId(), hbciTanSubmit.getMsgNum());
        AbstractHBCIJob paymentGV = hbciTwoStepMechanism.getProcess() == 1 ? this.submitProcess1(submitPaymentRequest.getPayment(), hbciTanSubmit, hbciPassport, hbciDialog) : this.submitProcess2(hbciTanSubmit, hbciDialog);
        HBCIExecStatus status = hbciDialog.execute(true);
        if (!status.isOK()) {
            throw new HbciException(status.getDialogStatus().getErrorString());
        }
        return this.orderIdFromJobResult(paymentGV.getJobResult());
    }

    private AbstractHBCIJob submitProcess1(AbstractPayment payment, HbciTanSubmit hbciTanSubmit, HbciPassport hbciPassport, HBCIDialog hbciDialog) {
        AbstractSEPAGV uebSEPAJob = this.createPaymentJob(payment, hbciPassport, hbciTanSubmit.getSepaPain());
        hbciDialog.addTask((AbstractHBCIJob)uebSEPAJob);
        return uebSEPAJob;
    }

    public AbstractHBCIJob submitProcess2(HbciTanSubmit hbciTanSubmit, HBCIDialog hbciDialog) {
        AbstractHBCIJob originJob = Optional.ofNullable(hbciTanSubmit.getOriginJobName()).map(s -> {
            AbstractHBCIJob result = HBCIJobFactory.newJob((String)hbciTanSubmit.getOriginJobName(), (HBCIPassportInternal)hbciDialog.getPassport());
            result.setSegVersion(hbciTanSubmit.getOriginSegVersion());
            return result;
        }).orElse(null);
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)hbciDialog.getPassport());
        hktan.setOriginJob(originJob);
        hktan.setParam("orderref", hbciTanSubmit.getOrderRef());
        hktan.setParam("process", "2");
        hktan.setParam("notlasttan", "N");
        hbciDialog.addTask((AbstractHBCIJob)hktan, false);
        return originJob;
    }

    abstract String orderIdFromJobResult(HBCIJobResult var1);

    abstract AbstractSEPAGV createPaymentJob(AbstractPayment var1, PinTanPassport var2, String var3);
}

