/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.job;

import domain.AbstractPayment;
import domain.HBCIProduct;
import domain.PaymentRequest;
import domain.TanChallenge;
import exception.HbciException;
import hbci4java.job.AbstractTanProcessJob;
import hbci4java.model.HbciCallback;
import hbci4java.model.HbciDialogFactory;
import hbci4java.model.HbciDialogRequest;
import hbci4java.model.HbciPassport;
import hbci4java.model.HbciTanSubmit;
import java.util.Optional;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.manager.HHDVersion;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;

public abstract class AbstractPaymentJob
extends AbstractTanProcessJob {
    abstract String getJobName(AbstractPayment.PaymentType var1);

    public HbciTanSubmit init(PaymentRequest paymentRequest) {
        HBCIExecStatus status;
        final HbciTanSubmit hbciTanSubmit = new HbciTanSubmit();
        hbciTanSubmit.setOriginJobName(this.getJobName(paymentRequest.getPayment().getPaymentType()));
        HbciCallback hbciCallback = new HbciCallback(){

            @Override
            public void tanChallengeCallback(String orderRef, String challenge, String challenge_hhd_uc, HHDVersion.Type type) {
                hbciTanSubmit.setOrderRef(orderRef);
                if (challenge != null) {
                    hbciTanSubmit.setTanChallenge(TanChallenge.builder().title(challenge).data(challenge_hhd_uc).build());
                }
            }
        };
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(paymentRequest.getBankCode() != null ? paymentRequest.getBankCode() : paymentRequest.getBankAccess().getBankCode()).customerId(paymentRequest.getBankAccess().getBankLogin()).login(paymentRequest.getBankAccess().getBankLogin2()).hbciPassportState(paymentRequest.getBankAccess().getHbciPassportState()).pin(paymentRequest.getPin()).callback(hbciCallback).build();
        dialogRequest.setHbciProduct(Optional.ofNullable(paymentRequest.getHbciProduct()).map(product -> new HBCIProduct(product.getProduct(), product.getVersion())).orElse(null));
        dialogRequest.setBpd(paymentRequest.getBpd());
        HBCIDialog dialog = HbciDialogFactory.createDialog(null, dialogRequest);
        HBCITwoStepMechanism hbciTwoStepMechanism = (HBCITwoStepMechanism)dialog.getPassport().getBankTwostepMechanisms().get(paymentRequest.getTanTransportType().getId());
        if (hbciTwoStepMechanism == null) {
            throw new HbciException("inavalid two stem mechanism: " + paymentRequest.getTanTransportType().getId());
        }
        dialog.getPassport().setCurrentSecMechInfo(hbciTwoStepMechanism);
        AbstractSEPAGV uebSEPA = this.createPaymentJob(paymentRequest.getPayment(), dialog.getPassport(), null);
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)dialog.getPassport());
        hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
        if (hbciTwoStepMechanism.getProcess() == 1) {
            this.hktanProcess1(hbciTanSubmit, hbciTwoStepMechanism, uebSEPA, hktan);
            dialog.addTask((AbstractHBCIJob)hktan, false);
        } else {
            this.hktanProcess2(dialog, uebSEPA, this.getOrderAccount(paymentRequest, dialog.getPassport()), hktan);
        }
        if (dialog.getPassport().tanMediaNeeded()) {
            hktan.setParam("tanmedia", paymentRequest.getTanTransportType().getMedium());
        }
        if (!(status = dialog.execute(false)).isOK()) {
            throw new HbciException(status.getDialogStatus().getErrorString());
        }
        hbciTanSubmit.setPassportState(new HbciPassport.State(dialog.getPassport()).toJson());
        hbciTanSubmit.setDialogId(dialog.getDialogID());
        hbciTanSubmit.setMsgNum(dialog.getMsgnum());
        hbciTanSubmit.setOriginSegVersion(uebSEPA.getSegVersion());
        return hbciTanSubmit;
    }

    private Konto getOrderAccount(PaymentRequest paymentRequest, PinTanPassport passport) {
        Konto orderAccount = passport.findAccountByAccountNumber(paymentRequest.getPayment().getSenderAccountNumber());
        orderAccount.iban = paymentRequest.getPayment().getSenderIban();
        orderAccount.bic = paymentRequest.getPayment().getSenderBic();
        return orderAccount;
    }
}

