/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.model;

import hbci4java.model.HbciCallback;
import hbci4java.model.HbciDialogRequest;
import hbci4java.model.HbciPassport;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.passport.PinTanPassport;

public class HbciDialogFactory {
    public static HBCIDialog createDialog(HbciPassport passport, HbciDialogRequest dialogRequest) {
        BankInfo bankInfo = Optional.ofNullable(HBCIUtils.getBankInfo((String)dialogRequest.getBankCode())).orElseThrow(() -> new IllegalArgumentException("Bank [" + dialogRequest.getBankCode() + "] not supported"));
        HbciPassport newPassport = Optional.ofNullable(passport).orElseGet(() -> HbciDialogFactory.createPassport(bankInfo.getPinTanVersion().getId(), dialogRequest.getBankCode(), dialogRequest.getCustomerId(), dialogRequest.getLogin(), dialogRequest.getCallback()));
        Optional.ofNullable(dialogRequest.getHbciPassportState()).ifPresent(s -> HbciPassport.State.readJson(dialogRequest.getHbciPassportState()).apply(newPassport));
        Optional.ofNullable(dialogRequest.getBpd()).ifPresent(bpd -> newPassport.setBPD((Map)bpd));
        newPassport.setPIN(dialogRequest.getPin());
        String url = bankInfo.getPinTanAddress();
        String proxyPrefix = System.getProperty("proxyPrefix", null);
        if (proxyPrefix != null) {
            url = proxyPrefix + url;
        }
        newPassport.setHost(url);
        return new HBCIDialog((PinTanPassport)newPassport);
    }

    public static HbciPassport createPassport(String hbciVersion, String bankCode, String customerId, String login, HbciCallback callback) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("kernel.rewriter", "InvalidSegment,WrongStatusSegOrder,WrongSequenceNumbers,MissingMsgRef,HBCIVersion,SigIdLeadingZero,InvalidSuppHBCIVersion,SecTypeTAN,KUmsDelimiters,KUmsEmptyBDateSets");
        properties.put("log.loglevel.default", "2");
        properties.put("default.hbciversion", "FinTS3");
        properties.put("client.passport.PinTan.checkcert", "1");
        properties.put("client.passport.PinTan.init", "1");
        properties.put("client.errors.ignoreJobNotSupported", "yes");
        properties.put("client.passport.country", "DE");
        properties.put("client.passport.blz", bankCode);
        properties.put("client.passport.customerId", customerId);
        properties.put("client.errors.ignoreCryptErrors", "yes");
        if (StringUtils.isNotBlank((CharSequence)login)) {
            properties.put("client.passport.userId", login);
        }
        return new HbciPassport(hbciVersion, properties, callback);
    }
}

