/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.job;

import domain.AbstractPayment;
import domain.StandingOrder;
import hbci4java.job.AbstractPaymentJob;
import hbci4java.model.HbciMapping;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVDauerSEPANew;
import org.kapott.hbci.GV_Result.GVRDauerNew;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewStandingOrderJob
extends AbstractPaymentJob {
    private static final Logger log = LoggerFactory.getLogger(NewStandingOrderJob.class);

    @Override
    protected AbstractSEPAGV createPaymentJob(AbstractPayment payment, PinTanPassport passport, String sepaPain) {
        StandingOrder standingOrder = (StandingOrder)payment;
        Konto src = passport.findAccountByAccountNumber(standingOrder.getSenderAccountNumber());
        src.iban = standingOrder.getSenderIban();
        src.bic = standingOrder.getSenderBic();
        Konto dst = new Konto();
        dst.name = standingOrder.getOtherAccount().getOwner();
        dst.iban = standingOrder.getOtherAccount().getIban();
        dst.bic = standingOrder.getOtherAccount().getBic();
        GVDauerSEPANew gvDauerSEPANew = new GVDauerSEPANew((HBCIPassportInternal)passport, sepaPain);
        gvDauerSEPANew.setParam("src", src);
        gvDauerSEPANew.setParam("dst", dst);
        gvDauerSEPANew.setParam("btg", new Value(standingOrder.getAmount()));
        gvDauerSEPANew.setParam("usage", standingOrder.getUsage());
        if (standingOrder.getFirstExecutionDate() != null) {
            gvDauerSEPANew.setParam("firstdate", standingOrder.getFirstExecutionDate().toString());
        }
        if (standingOrder.getCycle() != null) {
            gvDauerSEPANew.setParam("timeunit", HbciMapping.cycleToTimeunit(standingOrder.getCycle()));
            gvDauerSEPANew.setParam("turnus", HbciMapping.cycleToTurnus(standingOrder.getCycle()));
        }
        gvDauerSEPANew.setParam("execday", standingOrder.getExecutionDay());
        if (standingOrder.getLastExecutionDate() != null) {
            gvDauerSEPANew.setParam("lastdate", standingOrder.getLastExecutionDate().toString());
        }
        gvDauerSEPANew.verifyConstraints();
        return gvDauerSEPANew;
    }

    @Override
    protected String getJobName(AbstractPayment.PaymentType paymentType) {
        return GVDauerSEPANew.getLowlevelName();
    }

    @Override
    protected String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return ((GVRDauerNew)paymentGV).getOrderId();
    }
}

