/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.job;

import domain.AbstractPayment;
import domain.SinglePayment;
import hbci4java.job.AbstractPaymentJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVTermUebSEPADel;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class DeleteFuturePaymentJob
extends AbstractPaymentJob {
    private String jobName;

    @Override
    protected AbstractSEPAGV createPaymentJob(AbstractPayment payment, PinTanPassport passport, String sepaPain) {
        SinglePayment singlePayment = (SinglePayment)payment;
        Konto src = passport.findAccountByAccountNumber(payment.getSenderAccountNumber());
        src.iban = payment.getSenderIban();
        src.bic = payment.getSenderBic();
        Konto dst = new Konto();
        dst.name = singlePayment.getReceiver();
        dst.iban = singlePayment.getReceiverIban();
        dst.bic = singlePayment.getReceiverBic();
        this.jobName = GVTermUebSEPADel.getLowlevelName();
        GVTermUebSEPADel sepadelgv = new GVTermUebSEPADel((HBCIPassportInternal)passport, this.jobName, sepaPain);
        sepadelgv.setParam("orderid", singlePayment.getOrderId());
        sepadelgv.setParam("date", singlePayment.getExecutionDate().toString());
        sepadelgv.setParam("src", src);
        sepadelgv.setParam("dst", dst);
        sepadelgv.setParam("btg", new Value(singlePayment.getAmount()));
        sepadelgv.setParam("usage", singlePayment.getPurpose());
        sepadelgv.verifyConstraints();
        return sepadelgv;
    }

    @Override
    protected String getJobName(AbstractPayment.PaymentType paymentType) {
        return this.jobName;
    }

    @Override
    protected String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return null;
    }
}

