/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.job;

import domain.AbstractPayment;
import domain.PaymentChallenge;
import domain.PaymentRequest;
import domain.request.SubmitPaymentRequest;
import exception.HbciException;
import hbci4java.model.HbciCallback;
import hbci4java.model.HbciDialogFactory;
import hbci4java.model.HbciDialogRequest;
import hbci4java.model.HbciPassport;
import hbci4java.model.HbciTanSubmit;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kapott.hbci.GV.AbstractHBCIJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVTAN2Step;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.manager.ChallengeInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIJobFactory;
import org.kapott.hbci.manager.HBCITwoStepMechanism;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.structures.Konto;

public abstract class AbstractPaymentJob {
    abstract AbstractSEPAGV createPaymentJob(AbstractPayment var1, PinTanPassport var2, String var3);

    abstract String getJobName(AbstractPayment.PaymentType var1);

    abstract String orderIdFromJobResult(HBCIJobResult var1);

    public HbciTanSubmit execute(PaymentRequest paymentRequest) {
        HBCIExecStatus status;
        final HbciTanSubmit hbciTanSubmit = new HbciTanSubmit();
        hbciTanSubmit.setOriginJobName(this.getJobName(paymentRequest.getPayment().getPaymentType()));
        HbciCallback hbciCallback = new HbciCallback(){

            @Override
            public void tanChallengeCallback(String orderRef, String challenge, String challenge_hhd_uc) {
                hbciTanSubmit.setOrderRef(orderRef);
                if (challenge != null) {
                    hbciTanSubmit.setPaymentChallenge(PaymentChallenge.builder().title(challenge).data(challenge_hhd_uc).build());
                }
            }
        };
        HbciDialogRequest dialogRequest = HbciDialogRequest.builder().bankCode(paymentRequest.getBankCode() != null ? paymentRequest.getBankCode() : paymentRequest.getBankAccess().getBankCode()).customerId(paymentRequest.getBankAccess().getBankLogin()).login(paymentRequest.getBankAccess().getBankLogin2()).hbciPassportState(paymentRequest.getBankAccess().getHbciPassportState()).pin(paymentRequest.getPin()).callback(hbciCallback).build();
        dialogRequest.setBpd(paymentRequest.getBpd());
        HBCIDialog dialog = HbciDialogFactory.createDialog(null, dialogRequest);
        HBCITwoStepMechanism hbciTwoStepMechanism = (HBCITwoStepMechanism)dialog.getPassport().getBankTwostepMechanisms().get(paymentRequest.getPayment().getTanMedia().getId());
        if (hbciTwoStepMechanism == null) {
            throw new HbciException("inavalid two stem mechanism: " + paymentRequest.getPayment().getTanMedia().getId());
        }
        dialog.getPassport().setCurrentSecMechInfo(hbciTwoStepMechanism);
        AbstractSEPAGV uebSEPA = this.createPaymentJob(paymentRequest.getPayment(), dialog.getPassport(), null);
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)dialog.getPassport());
        hktan.setSegVersion(hbciTwoStepMechanism.getSegversion());
        if (hbciTwoStepMechanism.getProcess() == 1) {
            this.hktanProcess1(hbciTanSubmit, hbciTwoStepMechanism, uebSEPA, hktan);
            dialog.addTask((AbstractHBCIJob)hktan, false);
        } else {
            this.hktanProcess2(dialog, uebSEPA, paymentRequest.getPayment(), hktan);
        }
        if (dialog.getPassport().tanMediaNeeded()) {
            hktan.setParam("tanmedia", paymentRequest.getPayment().getTanMedia().getMedium());
        }
        if (!(status = dialog.execute(false)).isOK()) {
            throw new HbciException(status.getDialogStatus().getErrorString());
        }
        hbciTanSubmit.setPassportState(new HbciPassport.State(dialog.getPassport()).toJson());
        hbciTanSubmit.setDialogId(dialog.getDialogID());
        hbciTanSubmit.setMsgNum(dialog.getMsgnum());
        hbciTanSubmit.setOriginSegVersion(uebSEPA.getSegVersion());
        return hbciTanSubmit;
    }

    private void hktanProcess1(HbciTanSubmit hbciTanSubmit, HBCITwoStepMechanism hbciTwoStepMechanism, AbstractSEPAGV sepagv, GVTAN2Step hktan) {
        hktan.setParam("process", hbciTwoStepMechanism.getProcess());
        hktan.setParam("notlasttan", "N");
        hktan.setParam("orderhash", sepagv.createOrderHash(hbciTwoStepMechanism.getSegversion()));
        hbciTanSubmit.setSepaPain(sepagv.getPainXml());
        if (StringUtils.equals((CharSequence)hbciTwoStepMechanism.getNeedchallengeklass(), (CharSequence)"J")) {
            ChallengeInfo cinfo = ChallengeInfo.getInstance();
            cinfo.applyParams((AbstractHBCIJob)sepagv, (AbstractHBCIJob)hktan, hbciTwoStepMechanism);
        }
    }

    private void hktanProcess2(HBCIDialog dialog, AbstractSEPAGV sepagv, AbstractPayment payment, GVTAN2Step hktan) {
        Konto src = dialog.getPassport().findAccountByAccountNumber(payment.getSenderAccountNumber());
        src.iban = payment.getSenderIban();
        src.bic = payment.getSenderBic();
        hktan.setParam("process", "4");
        hktan.setParam("orderaccount", src);
        List messages = dialog.addTask((AbstractHBCIJob)sepagv);
        messages.add(hktan);
    }

    public String execute(final SubmitPaymentRequest submitPaymentRequest) {
        HbciTanSubmit hbciTanSubmit = (HbciTanSubmit)submitPaymentRequest.getTanSubmit();
        HbciPassport.State state = HbciPassport.State.readJson(hbciTanSubmit.getPassportState());
        HbciPassport hbciPassport = HbciDialogFactory.createPassport(state.hbciVersion, state.blz, state.customerId, state.userId, new HbciCallback(){

            @Override
            public String needTAN() {
                return submitPaymentRequest.getTan();
            }
        });
        state.apply(hbciPassport);
        hbciPassport.setPIN(submitPaymentRequest.getPin());
        HBCITwoStepMechanism hbciTwoStepMechanism = (HBCITwoStepMechanism)hbciPassport.getBankTwostepMechanisms().get(submitPaymentRequest.getPayment().getTanMedia().getId());
        hbciPassport.setCurrentSecMechInfo(hbciTwoStepMechanism);
        HBCIDialog hbciDialog = new HBCIDialog((PinTanPassport)hbciPassport, hbciTanSubmit.getDialogId(), hbciTanSubmit.getMsgNum());
        AbstractHBCIJob paymentGV = hbciTwoStepMechanism.getProcess() == 1 ? this.paymentProcess1(submitPaymentRequest.getPayment(), hbciTanSubmit, hbciPassport, hbciDialog) : this.paymentProcess2(hbciTanSubmit, hbciDialog);
        HBCIExecStatus status = hbciDialog.execute(true);
        if (!status.isOK()) {
            throw new HbciException(status.getDialogStatus().getErrorString());
        }
        return this.orderIdFromJobResult(paymentGV.getJobResult());
    }

    private AbstractHBCIJob paymentProcess1(AbstractPayment payment, HbciTanSubmit hbciTanSubmit, HbciPassport hbciPassport, HBCIDialog hbciDialog) {
        AbstractSEPAGV uebSEPAJob = this.createPaymentJob(payment, hbciPassport, hbciTanSubmit.getSepaPain());
        hbciDialog.addTask((AbstractHBCIJob)uebSEPAJob);
        return uebSEPAJob;
    }

    private AbstractHBCIJob paymentProcess2(HbciTanSubmit hbciTanSubmit, HBCIDialog hbciDialog) {
        AbstractHBCIJob originJob = HBCIJobFactory.newJob((String)hbciTanSubmit.getOriginJobName(), (HBCIPassportInternal)hbciDialog.getPassport());
        originJob.setSegVersion(hbciTanSubmit.getOriginSegVersion());
        GVTAN2Step hktan = new GVTAN2Step((HBCIPassportInternal)hbciDialog.getPassport());
        hktan.setOriginJob(originJob);
        hktan.setParam("orderref", hbciTanSubmit.getOrderRef());
        hktan.setParam("process", "2");
        hktan.setParam("notlasttan", "N");
        hbciDialog.addTask((AbstractHBCIJob)hktan, false);
        return originJob;
    }
}

