/*
 * Decompiled with CFR 0.152.
 */
package hbci4java;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import domain.AbstractPayment;
import domain.BankAccess;
import domain.BankAccount;
import domain.BankApi;
import domain.BankApiUser;
import domain.PaymentRequest;
import domain.request.CreateConsentRequest;
import domain.request.LoadAccountInformationRequest;
import domain.request.LoadBalanceRequest;
import domain.request.LoadBookingsRequest;
import domain.request.SubmitPaymentRequest;
import domain.response.LoadAccountInformationResponse;
import domain.response.LoadBookingsResponse;
import exception.InvalidPinException;
import hbci4java.job.AbstractPaymentJob;
import hbci4java.job.AccountInformationJob;
import hbci4java.job.BulkPaymentJob;
import hbci4java.job.DeleteFuturePaymentJob;
import hbci4java.job.DeleteStandingOrderJob;
import hbci4java.job.LoadBalanceJob;
import hbci4java.job.LoadBookingsJob;
import hbci4java.job.NewStandingOrderJob;
import hbci4java.job.SinglePaymentJob;
import hbci4java.model.HbciCallback;
import hbci4java.model.HbciDialogFactory;
import hbci4java.model.HbciDialogRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.BankInfo;
import org.kapott.hbci.manager.HBCIDialog;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spi.OnlineBankingService;

public class Hbci4JavaBanking
implements OnlineBankingService {
    private static final Logger log = LoggerFactory.getLogger(Hbci4JavaBanking.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public Hbci4JavaBanking() {
        this(null);
    }

    public Hbci4JavaBanking(InputStream customBankConfigInput) {
        try (InputStream inputStream = Optional.ofNullable(customBankConfigInput).orElseGet(this::getDefaultBanksInput);){
            HBCIUtils.refreshBLZList((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
    }

    private InputStream getDefaultBanksInput() {
        try {
            return HBCIUtils.class.getClassLoader().getResource("blz.properties").openStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BankApi bankApi() {
        return BankApi.HBCI;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(Optional<String> bankingUrl, BankAccess bankAccess, String pin) {
        return null;
    }

    public void removeUser(Optional<String> bankingUrl, BankApiUser bankApiUser) {
    }

    public LoadAccountInformationResponse loadBankAccounts(Optional<String> bankingUrl, LoadAccountInformationRequest request) {
        return this.loadBankAccounts(bankingUrl, request, null);
    }

    public LoadAccountInformationResponse loadBankAccounts(Optional<String> bankingUrl, LoadAccountInformationRequest request, HbciCallback callback) {
        try {
            this.checkBankExists(request.getBankCode(), bankingUrl);
            return AccountInformationJob.loadBankAccounts(request, callback);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public Object createPayment(Optional<String> bankingUrl, PaymentRequest paymentRequest) {
        try {
            this.checkBankExists(paymentRequest.getBankCode(), bankingUrl);
            return this.createPaymentJob(paymentRequest.getPayment()).execute(paymentRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public Object deletePayment(Optional<String> bankingUrl, PaymentRequest paymentRequest) {
        try {
            this.checkBankExists(paymentRequest.getBankCode(), bankingUrl);
            return this.createDeleteJob(paymentRequest.getPayment()).execute(paymentRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public String submitPayment(Optional<String> bankingUrl, SubmitPaymentRequest submitPaymentRequest) {
        try {
            return this.createPaymentJob(submitPaymentRequest.getPayment()).execute(submitPaymentRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public String submitDelete(Optional<String> bankingUrl, SubmitPaymentRequest submitPaymentRequest) {
        try {
            return this.createDeleteJob(submitPaymentRequest.getPayment()).execute(submitPaymentRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public void removeBankAccount(Optional<String> bankingUrl, BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public LoadBookingsResponse loadBookings(Optional<String> bankingUrl, LoadBookingsRequest loadBookingsRequest) {
        try {
            this.checkBankExists(loadBookingsRequest.getBankCode(), bankingUrl);
            return LoadBookingsJob.loadBookings(loadBookingsRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public List<BankAccount> loadBalances(Optional<String> bankingUrl, LoadBalanceRequest loadBalanceRequest) {
        try {
            this.checkBankExists(loadBalanceRequest.getBankCode(), bankingUrl);
            return LoadBalanceJob.loadBalances(loadBalanceRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public HBCIDialog createDialog(Optional<String> bankingUrl, HbciDialogRequest dialogRequest) {
        try {
            this.checkBankExists(dialogRequest.getBankCode(), bankingUrl);
            return HbciDialogFactory.createDialog(null, dialogRequest);
        }
        catch (HBCI_Exception e) {
            throw this.handleHbciException(e);
        }
    }

    public boolean bankSupported(String bankCode) {
        BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
        return bankInfo != null && bankInfo.getPinTanVersion() != null;
    }

    public boolean accountInformationConsentRequired(BankApiUser bankApiUser, String accountReference) {
        return false;
    }

    public void createAccountInformationConsent(Optional<String> bankingUrl, CreateConsentRequest startScaRequest) {
    }

    private void checkBankExists(String bankCode, Optional<String> bankingUrl) {
        bankingUrl.ifPresent(s -> {
            BankInfo bankInfo = HBCIUtils.getBankInfo((String)bankCode);
            if (bankInfo == null) {
                bankInfo = new BankInfo();
                bankInfo.setBlz(bankCode);
                bankInfo.setPinTanAddress(s);
                bankInfo.setPinTanVersion(HBCIVersion.HBCI_300);
                HBCIUtils.addBankInfo((BankInfo)bankInfo);
            }
        });
    }

    private AbstractPaymentJob createPaymentJob(AbstractPayment payment) {
        switch (payment.getPaymentType()) {
            case SINGLE_PAYMENT: 
            case FUTURE_PAYMENT: {
                return new SinglePaymentJob();
            }
            case BULK_PAYMENT: {
                return new BulkPaymentJob();
            }
            case STANDING_ORDER: {
                return new NewStandingOrderJob();
            }
        }
        throw new IllegalArgumentException("invalid payment type " + payment.getPaymentType());
    }

    private AbstractPaymentJob createDeleteJob(AbstractPayment payment) {
        switch (payment.getPaymentType()) {
            case FUTURE_PAYMENT: {
                return new DeleteFuturePaymentJob();
            }
            case STANDING_ORDER: {
                return new DeleteStandingOrderJob();
            }
        }
        throw new IllegalArgumentException("invalid payment type " + payment.getPaymentType());
    }

    private RuntimeException handleHbciException(HBCI_Exception e) {
        Throwable processException = e;
        while (processException.getCause() != null && !(processException.getCause() instanceof InvalidPinException)) {
            processException = processException.getCause();
        }
        if (processException.getCause() != null && processException.getCause() instanceof InvalidPinException) {
            return (InvalidPinException)processException.getCause();
        }
        return e;
    }
}

