/*
 * Decompiled with CFR 0.152.
 */
package hbci4java.job;

import domain.AbstractPayment;
import domain.BulkPayment;
import domain.SinglePayment;
import hbci4java.job.AbstractPaymentJob;
import org.kapott.hbci.GV.AbstractSEPAGV;
import org.kapott.hbci.GV.GVMultiUebSEPA;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;

public class BulkPaymentJob
extends AbstractPaymentJob {
    @Override
    protected AbstractSEPAGV createPaymentJob(AbstractPayment abstractPayment, PinTanPassport passport, String sepaPain) {
        BulkPayment bulkPayment = (BulkPayment)abstractPayment;
        Konto src = passport.findAccountByAccountNumber(bulkPayment.getSenderAccountNumber());
        src.iban = bulkPayment.getSenderIban();
        src.bic = bulkPayment.getSenderBic();
        GVMultiUebSEPA uebSEPA = new GVMultiUebSEPA((HBCIPassportInternal)passport, GVMultiUebSEPA.getLowlevelName(), sepaPain);
        uebSEPA.setParam("src", src);
        for (int i = 0; i < bulkPayment.getPayments().size(); ++i) {
            SinglePayment payment = (SinglePayment)bulkPayment.getPayments().get(i);
            Konto dst = new Konto();
            dst.name = payment.getReceiver();
            dst.iban = payment.getReceiverIban();
            dst.bic = payment.getReceiverBic();
            uebSEPA.setParam("dst", Integer.valueOf(i), dst);
            uebSEPA.setParam("btg", Integer.valueOf(i), new Value(payment.getAmount()));
            uebSEPA.setParam("usage", Integer.valueOf(i), payment.getPurpose());
        }
        uebSEPA.verifyConstraints();
        return uebSEPA;
    }

    @Override
    protected String getJobName(AbstractPayment.PaymentType paymentType) {
        return GVMultiUebSEPA.getLowlevelName();
    }

    @Override
    protected String orderIdFromJobResult(HBCIJobResult paymentGV) {
        return null;
    }
}

